<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- meta -->
    {PPP INCLUDE:template2_meta_header.php}

    <!-- system header -->
    {PPP INCLUDE:template2_sys_header.php}

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@400;500;600&family=DM+Sans:wght@400;500;600&family=Noto+Sans+JP:wght@400;500&family=Noto+Serif+JP:wght@400;500&display=swap" rel="stylesheet">

    <!-- Theme CSS -->
    <link rel="stylesheet" href="{PPP SITE_URL}/system_resource/css/recss.css">
    <link rel="stylesheet" href="{PPP THEME_URL}/css/styles.css">
    <link rel="stylesheet" href="{PPP:site_url}/user_resource/user.css">

    <style>
        :root {
            --theme-accent-color: {
                PPP THEME: accent_color
            }

            ;
        }
    </style>
</head>

<body>
    {PPP INCLUDE:template2_admin_header.php}

    <div class="search-container">
        <!-- Header -->
        <header>
            <a href="{PPP:site_url}" class="global-header-link">{PPP:site_title}</a>
            <a href="" data-log-return class="article-back">
                <i class="fa-solid fa-arrow-left"></i>
                <span>Back</span>
            </a>
        </header>

        <!-- Search Form -->
        <div class="search-header">
            <form action="/search" method="get" class="search-form">
                <div class="p-search-input">
                    <button data-search type="submit">
                        <i class="fa-solid fa-magnifying-glass"></i>
                    </button>
                    <input data-search-input type="text" onclick="this.select();" value="{PPP:searchs}" name="q" placeholder="Search...">
                    <button data-search-clear type="button">
                        <i class="fa-regular fa-circle-xmark"></i>
                    </button>
                </div>

                <div class="sort-control">
                    <label for="sort-type">Sort by</label>
                    <select data-search-order id="sort-type" name="sort-type">
                        <option value="0" {PPP:sort_type_select[0]}>Created (Newest)</option>
                        <option value="1" {PPP:sort_type_select[1]}>Created (Oldest)</option>
                        <option value="2" {PPP:sort_type_select[2]}>Updated (Newest)</option>
                        <option value="3" {PPP:sort_type_select[3]}>Updated (Oldest)</option>
                    </select>
                </div>
            </form>
        </div>

        <!-- Message -->
        {PPP IF:message}
        <div class="search-message">
            {PPP:message}
        </div>
        {/PPP IF}

        <!-- Search Results -->
        <div class="search-results">
            {PPP LOOP:articles}
            <div class="search-item" data-log-link>
                <a href="{PPP:articles.url}" class="search-item-thumb">
                    <img src="{PPP:articles.thumbnail_path}" alt="{PPP:articles.title}" class="{PPP:articles.thumbnail_class}">
                </a>
                <div class="search-item-info">
                    <h3 class="search-item-title">
                        <a href="{PPP:articles.url}">{PPP:articles.title}</a>
                    </h3>
                    <div class="search-item-date">{PPP:articles.created_at}</div>
                    <p class="search-item-caption">{PPP:articles.caption}</p>
                </div>
            </div>
            {/PPP LOOP}
        </div>

        <!-- Pagination -->
        <div class="pagination">
            {PPP INCLUDE:template2_parts_pagination.php}
        </div>

        <!-- Footer -->
        <footer class="portfolio-footer">
            {PPP:powered_info}
        </footer>
    </div>
</body>

</html>