<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- meta -->
    {PPP INCLUDE:template2_meta_header.php}

    <!-- system header -->
    {PPP INCLUDE:template2_sys_header.php}

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@400;500;600&family=DM+Sans:wght@400;500;600&family=Noto+Sans+JP:wght@400;500&family=Noto+Serif+JP:wght@400;500&display=swap" rel="stylesheet">

    <!-- Theme CSS -->
    <link rel="stylesheet" href="{PPP SITE_URL}/system_resource/css/recss.css">
    <link rel="stylesheet" href="{PPP THEME_URL}/css/styles.css">
    <link rel="stylesheet" href="{PPP:site_url}/user_resource/user.css">

    <style>
        :root {
            --theme-accent-color: {
                PPP THEME: accent_color
            }

            ;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            document.querySelector('#conform_button').addEventListener("click", function() {
                location.replace("{PPP:redirect_url}")
            });

            document.querySelector("#cancel_button").addEventListener("click", function() {
                location.href = "{PPP:return_url}";
            });
        });
    </script>
</head>

<body>
    {PPP INCLUDE:template2_admin_header.php}

    <div class="gate-container">
        <div class="gate-box">
            <h1 class="gate-title">{PPP:title}</h1>

            <div class="gate-content">
                {PPP:contents}
                <p>
                    {PPP IF:type == 0}
                    This site contains content that may not be suitable for those under 18 years of age.
                    {PPP ELSE}
                    This article contains content that may not be suitable for those under 18 years of age.
                    {/PPP IF}
                </p>
                <p>
                    Are you 18 years of age or older?
                </p>
            </div>

            <div class="gate-buttons">
                <button id="conform_button" class="gate-btn gate-btn-primary">
                    I am 18 or older and consent to view NSFW content
                </button>
                <button id="cancel_button" class="gate-btn gate-btn-secondary">{PPP:cancel_title}</button>
            </div>
        </div>
    </div>

    <footer class="portfolio-footer" style="position: fixed; bottom: 0; left: 0; right: 0; background: var(--color-bg);">
        {PPP:powered_info}
    </footer>
</body>

</html>