<style>
    .article-list-outline {
        margin-top: 2rem;
    }

    .article-list-outline ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .article-list-outline li {
        padding: 1rem 0;
        border-bottom: 1px solid var(--color-border-light, #f0f0f0);
    }

    .article-list-outline li:first-child {
        padding-top: 0;
    }

    .article-list-outline-link {
        display: flex;
        justify-content: space-between;
        align-items: baseline;
        gap: 1rem;
        color: var(--color-text-primary, #2a2a2a);
        text-decoration: none;
        transition: color 0.2s ease;
    }

    .article-list-outline-link:hover {
        color: var(--color-accent, #555);
    }

    .article-list-outline-title {
        font-family: var(--font-display, 'Cormorant Garamond', serif);
        font-size: 1.1rem;
        font-weight: 500;
        flex: 1;
        min-width: 0;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .article-list-outline-date {
        font-size: 0.85rem;
        color: var(--color-text-tertiary, #999);
        white-space: nowrap;
    }

    @media (max-width: 480px) {
        .article-list-outline-link {
            flex-direction: column;
            gap: 0.3rem;
        }

        .article-list-outline-date {
            font-size: 0.8rem;
        }
    }
</style>

<div class="article-list article-list-outline">
    <ul>
        {PPP LOOP:articles}
        <li>
            <a href="{PPP:articles.url}" class="article-list-outline-link" data-log-link>
                <span class="article-list-outline-title">{PPP:articles.title}</span>
                <span class="article-list-outline-date">{PPP:articles.created_at}</span>
            </a>
        </li>
        {/PPP LOOP}
    </ul>
    {PPP INCLUDE:template2_parts_pagination.php}
</div>