<style>
    .article-list-portfolio {
        margin-top: 2rem;
    }

    .article-list-portfolio ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .article-list-item {
        display: flex;
        gap: 1.5rem;
        padding: 1.5rem 0;
        border-bottom: 1px solid var(--color-border-light, #f0f0f0);
        transition: background-color 0.2s ease;
    }

    .article-list-item:first-child {
        padding-top: 0;
    }

    .article-list-item:hover {
        background-color: var(--color-bg, #fafafa);
        margin: 0 -1rem;
        padding-left: 1rem;
        padding-right: 1rem;
    }

    .article-list-thumb {
        flex-shrink: 0;
        width: 100px;
        height: 100px;
        border-radius: 4px;
        overflow: hidden;
        background-color: var(--color-bg, #fafafa);
    }

    .article-list-thumb img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .article-list-thumb-text {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0.5rem;
        text-align: center;
        font-size: 0.8rem;
        color: var(--color-text-secondary, #666);
    }

    .article-list-info {
        flex: 1;
        min-width: 0;
    }

    .article-list-title {
        font-family: var(--font-display, 'Cormorant Garamond', serif);
        font-size: 1.1rem;
        font-weight: 500;
        margin-bottom: 0.3rem;
    }

    .article-list-title a {
        color: var(--color-text-primary, #2a2a2a);
        text-decoration: none;
    }

    .article-list-title a:hover {
        color: var(--color-accent, #555);
    }

    .article-list-date {
        font-size: 0.8rem;
        color: var(--color-text-tertiary, #999);
        margin-bottom: 0.5rem;
    }

    .article-list-caption {
        font-size: 0.9rem;
        color: var(--color-text-secondary, #666);
        line-height: 1.6;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    @media (max-width: 768px) {
        .article-list-item {
            gap: 1rem;
        }

        .article-list-thumb {
            width: 80px;
            height: 80px;
        }

        .article-list-title {
            font-size: 1rem;
        }
    }
</style>

<div class="article-list article-list-portfolio">
    <ul>
        {PPP LOOP:articles}
        <li>
            <div class="article-list-item" data-log-link>
                <a href="{PPP:articles.url}" class="article-list-thumb">
                    {PPP IF:articles.thumbnail_title}
                    <span class="article-list-thumb-text">{PPP:articles.thumbnail_title}</span>
                    {PPP ELSE}
                    <img src="{PPP:articles.thumbnail_path}" alt="{PPP:articles.title}" class="{PPP:articles.thumbnail_class}">
                    {/PPP IF}
                </a>
                <div class="article-list-info">
                    <h3 class="article-list-title">
                        <a href="{PPP:articles.url}">{PPP:articles.title}</a>
                    </h3>
                    <div class="article-list-date">{PPP:articles.created_at}</div>
                    <p class="article-list-caption">{PPP:articles.caption}</p>
                </div>
            </div>
        </li>
        {/PPP LOOP}
    </ul>
    {PPP INCLUDE:template2_parts_pagination.php}
</div>