<style>
    .article-list-grid {
        margin-top: 2rem;
    }

    .article-list-grid ul {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 16px;
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .article-list-grid li {
        position: relative;
        aspect-ratio: 1;
        overflow: hidden;
        background-color: var(--color-surface, #fff);
        border-radius: 4px;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.04);
        transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .article-list-grid li:hover {
        box-shadow: 0 12px 32px rgba(0, 0, 0, 0.12);
        transform: translateY(-4px);
    }

    .article-list-grid li a {
        display: block;
        width: 100%;
        height: 100%;
    }

    .article-list-grid-thumb {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .article-list-grid li:hover .article-list-grid-thumb {
        transform: scale(1.05);
    }

    .article-list-grid-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 1.5rem 1rem 1rem;
        background: linear-gradient(to top, rgba(0, 0, 0, 0.6) 0%, transparent 100%);
        opacity: 0;
        transition: opacity 0.35s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .article-list-grid li:hover .article-list-grid-overlay {
        opacity: 1;
    }

    .article-list-grid-title {
        color: #fff;
        font-family: var(--font-display, 'Cormorant Garamond', serif);
        font-size: 0.95rem;
        font-weight: 500;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .article-list-grid .text-only {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 1.5rem;
        background-color: var(--color-bg, #fafafa);
    }

    .article-list-grid .text-only-title {
        font-family: var(--font-display, 'Cormorant Garamond', serif);
        font-size: 1rem;
        color: var(--color-text-secondary, #666);
        text-align: center;
        word-break: break-word;
    }

    @media (max-width: 768px) {
        .article-list-grid ul {
            grid-template-columns: repeat(auto-fill, minmax(140px, 1fr));
            gap: 12px;
        }

        .article-list-grid-overlay {
            opacity: 1;
            background: linear-gradient(to top, rgba(0, 0, 0, 0.5) 0%, transparent 70%);
        }
    }

    @media (max-width: 480px) {
        .article-list-grid ul {
            grid-template-columns: repeat(2, 1fr);
            gap: 8px;
        }
    }
</style>

<div class="article-list article-list-grid">
    <ul>
        {PPP LOOP:articles}
        <li class="{PPP IF:articles.thumbnail_title}text-only{/PPP IF}">
            <a href="{PPP:articles.url}" data-log-link>
                {PPP IF:articles.thumbnail_title}
                <span class="text-only-title">{PPP:articles.thumbnail_title}</span>
                {PPP ELSE}
                <img src="{PPP:articles.thumbnail_path}" alt="{PPP:articles.title}" class="article-list-grid-thumb {PPP:articles.thumbnail_class}">
                <div class="article-list-grid-overlay">
                    <span class="article-list-grid-title">{PPP:articles.title}</span>
                </div>
                {/PPP IF}
            </a>
        </li>
        {/PPP LOOP}
    </ul>
    {PPP INCLUDE:template2_parts_pagination.php}
</div>