<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- meta -->
    {PPP INCLUDE:template2_meta_header.php}

    <!-- system header -->
    {PPP INCLUDE:template2_sys_header.php}

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@400;500;600&family=DM+Sans:wght@400;500;600&family=Noto+Sans+JP:wght@400;500&family=Noto+Serif+JP:wght@400;500&display=swap" rel="stylesheet">

    <!-- Theme CSS -->
    <link rel="stylesheet" href="{PPP SITE_URL}/system_resource/css/recss.css">
    <link rel="stylesheet" href="{PPP THEME_URL}/css/styles.css">
    <link rel="stylesheet" href="{PPP:site_url}/user_resource/user.css">

    <style>
        :root {
            --theme-accent-color: {
                PPP THEME: accent_color
            }

            ;
        }
    </style>
</head>

<body>
    {PPP INCLUDE:template2_admin_header.php}

    <div class="portfolio-container">
        <!-- Sidebar -->
        <aside class="portfolio-sidebar">
            <div class="sidebar-inner">
                <a href="{PPP:site_url}/about">
                    <img src="{PPP:site_author_icon}" alt="{PPP:site_author}" class="author-avatar">
                </a>
                <h1 class="author-name">{PPP:site_author}</h1>
                <p class="author-tagline">{PPP THEME:author_tagline}</p>

                {PPP IF:contents}
                {PPP IF:page_type==index}
                <div class="author-bio">
                    {PPP:contents}
                </div>
                {/PPP IF}

                <!-- Social Links -->
                {PPP IF:accounts}
                <div class="social-links">
                    {PPP LOOP:accounts}
                    {PPP:accounts.icon_html}
                    {/PPP LOOP}
                </div>
                {/PPP IF}
                {/PPP IF}
                <!-- Navigation -->
                {PPP IF:home_menu}
                <nav class="sidebar-nav">
                    <ul>
                        {PPP LOOP:home_menu}
                        <li class="home-menu-item {PPP:home_menu.class}">
                            <a href="{PPP:home_menu.url}">{PPP:home_menu.title}</a>
                        </li>
                        {/PPP LOOP}
                    </ul>
                </nav>
                {/PPP IF}
            </div>
        </aside>

        <!-- Main Content -->
        <main class="portfolio-main">
            {PPP LAYOUT_CONTENTS}

            <footer class="portfolio-footer">
                {PPP:powered_info}
            </footer>
        </main>
    </div>
</body>

</html>