{PPP LAYOUT:template2_layout.php}

<div class="article-container">
    <!-- Header Navigation -->
    <header>
        <a href="{PPP:site_url}" class="global-header-link">{PPP:site_title}</a>
        <a href="" data-log-return class="article-back">
            <i class="fa-solid fa-arrow-left"></i>
            <span>Back</span>
        </a>
    </header>

    <!-- Article Header -->
    <div class="article-header">
        <h1 class="article-title">{PPP:title}</h1>

        <div class="article-meta">
            <span class="article-date">{PPP:created_at}</span>
        </div>

        {PPP IF:tag_links}
        <div class="article-tags">
            {PPP:tag_links_html}
        </div>
        {/PPP IF}
    </div>

    <!-- Article Content -->
    <div class="article-content">
        {PPP IF:caption}
        <div class="article-caption">{PPP:caption}</div>
        {/PPP IF}

        <div class="article-body">
            {PPP:contents}
        </div>

        {PPP IF:simple_mode}
        <div class="article-media">
            {PPP LOOP:media}
            {PPP:media.thumbnail_html}
            {/PPP LOOP}
        </div>
        {/PPP IF}
    </div>

    <!-- Article Controls -->
    <div class="article-controls">
        <!-- Like Button -->
        {PPP IF:settings['use_feedback']}
        <div class="like-section">
            {PPP IF:settings['show_likes']}
            {PPP IF:likes}
            <div class="like-count">
                <i class="fa-regular fa-heart"></i> {PPP:likes}
            </div>
            {/PPP IF}
            {/PPP IF}
            <span class="p-button-like-it" data-like-it>Like</span>
        </div>

        {PPP IF:settings['show_share_button']}
        <div class="share-section">
            <a href="https://twitter.com/share?ref_src=twsrc%5Etfw" target="_blank" class="twitter-share-button" data-show-count="false">Tweet</a>
            <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
        </div>
        {/PPP IF}
        {/PPP IF}

        <!-- Navigation -->
        {PPP IF:settings['move_link_type'] != 0}
        <nav class="article-nav">
            <span class="article-nav-prev">{PPP:prev_link_html}</span>
            <span class="article-nav-sep">|</span>
            <span class="article-nav-next">{PPP:next_link_html}</span>
        </nav>
        {/PPP IF}

        {PPP:csrf}

        <button id="return-button" class="p-button" data-log-return>Back to Gallery</button>
    </div>