<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- meta -->
    {PPP INCLUDE:template2_meta_header.php}

    <!-- system header -->
    {PPP INCLUDE:template2_sys_header.php}

    <!-- template resouce -->
    <link rel="stylesheet" href="{PPP SITE_URL}/system_resource/css/recss.css">
    <link rel="stylesheet" href="{PPP THEME_URL}/css/styles.css">
    <link rel="stylesheet" href="{PPP:site_url}/user_resource/user.css">

    <style>
        .article-container {
            max-width: 900px;
            margin-top: 2rem;
            margin-bottom: 2rem;
            border-radius: 15px;
        }

        .section {
            margin-bottom: 1rem;
        }

        .tag {
            font-size: 0.8rem;
        }

        .global-header {
            margin-left: 0.5rem;
        }

        .header {
            margin-left: 0.5rem;
        }

        .control {
            text-align: center;
        }

        .section {
            margin-bottom: 1rem;
        }

        select {
            margin-left: 0.5rem;
            margin-right: 0.5rem;
        }

        .search-list {
            margin-top: 2rem;
        }

        .p-search-button {
            color: var(--text-primary);
        }

        @scope(.search-list) {
            li {
                list-style: none;
            }

            div.list-item {
                font-size: 1rem;
                display: grid;
                grid-template-columns: min-content 8em 3em auto;
                grid-template-rows: 1em 2em auto;
                margin: 0 2rem 1rem 2rem;
                max-height: 150px;
                overflow: hidden;
                padding: 15px;
                background: var(--bg-secondary);
                border: 2px solid var(--border-color);
                border-radius: 8px;
                transition: all 0.3s ease;
            }

            div.list-item:hover {
                border-color: var(--accent-cyan);
                background: rgba(26, 31, 58, 0.8);
                box-shadow: 0 8px 24px rgba(0, 217, 255, 0.1);
                transform: translateX(5px);
            }

            .list-item-thumb {
                grid-column: 2;
                grid-row: span 3;
                margin-right: 0.5em;
                width: var(--search-thumbnail-width, 100px);
                height: var(--search-thumbnail-height, 100px);
                background-color: var(--bg-tertiary);

                overflow: hidden;
                background-size: cover;
                background-position: center center;
                transition: all 0.3s ease;
            }

            .list-item:hover .list-item-thumb {
                border-color: var(--accent-cyan);
                box-shadow: 0 0 15px rgba(0, 217, 255, 0.2);
            }

            .list-item-thumb-in {
                position: relative;
                width: var(--search-thumbnail-width, 100px);
                height: var(--search-thumbnail-height, 100px);
                border: 2px solid var(--border-color);

            }

            .list-item-created-at {
                text-wrap: nowrap;
                grid-column: 3;
                font-size: 0.7em;
                margin-right: 1em;
                color: var(--text-secondary);
            }

            .list-item-views {
                grid-column: 4;
                font-size: 0.7em;
                text-wrap: nowrap;
                min-width: 3em;
                color: var(--text-secondary);
            }

            .list-item-like {
                grid-column: 5;
                font-size: 0.7em;
                text-wrap: nowrap;
                min-width: 3em;
                color: var(--text-secondary);
            }

            .list-item-title {
                align-self: center;
                grid-column: 3 / span 3;
                text-wrap: nowrap;
                line-height: 160%;
                font-weight: 600;
                color: var(--text-primary);
            }

            .list-item-title a {
                color: var(--link-color);
                font-weight: 600;
            }

            .list-item-title a:hover {
                color: var(--accent-purple);
            }

            .list-item-caption {
                grid-column: 3 / span 3;
                font-size: 0.8em;
                overflow: hidden;
                line-height: 140%;
                max-height: var(--search-thumbnail-height, 100px);
                color: var(--text-secondary);
            }

            .list-item-caption a {
                color: var(--text-secondary);
            }

            .list-item-caption a:hover {
                color: var(--link-color);
            }

            .list-item-thumb-image {
                width: 100%;
                height: 100%;
                object-fit: cover;
                object-position: center;
                transition: filter 0.3s ease;
            }

            .list-item:hover .list-item-thumb-image {
                filter: brightness(1.1) contrast(1.05);
            }

            .list-item-thumb-title {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                display: grid;
                place-content: center;
                background: rgba(10, 14, 39, 0.6);
                color: var(--accent-cyan);
                font-weight: 600;
            }
        }

        .sort-control {
            padding: 20px;
            background: linear-gradient(135deg, rgba(37, 45, 71, 0.5), rgba(26, 31, 58, 0.5));
            border: 2px solid var(--border-color);
            border-radius: 8px;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }

        .sort-control:hover {
            border-color: var(--accent-cyan);
            box-shadow: 0 8px 24px rgba(0, 217, 255, 0.1);
        }

        .sort-control label {
            color: var(--text-primary);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            display: inline-block;
            margin-right: 0.5rem;
        }

        .control-area {
            padding: 15px;
            background: linear-gradient(135deg, rgba(37, 45, 71, 0.5), rgba(26, 31, 58, 0.5));
            border: 2px solid var(--border-color);
            border-radius: 8px;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }

        .control-area:hover {
            border-color: var(--accent-cyan);
            box-shadow: 0 8px 24px rgba(0, 217, 255, 0.1);
        }

        .message-area {
            padding: 20px;
            background: linear-gradient(135deg, rgba(0, 217, 255, 0.1), rgba(124, 58, 237, 0.1));
            border: 2px solid var(--border-color);
            border-radius: 8px;
            margin-bottom: 1rem;
            color: var(--text-primary);
            text-align: center;
        }
    </style>
</head>

<body>
    {PPP INCLUDE:template2_admin_header.php}
    <div class="global-header">
        <a href="./">
            {PPP:site_title}
        </a>
    </div>
    <div class="header">
        <a href="" data-log-return>
            &lt; 戻る
        </a>
    </div>
    <div class="main-container article-container">
        <div class="main-contents">
            <form action="/search" method="get">
                <div class="control-area section">

                    <div class="p-search-input">
                        <button data-search><i class="p-search-button fa-solid fa-magnifying-glass"></i></button>
                        <input data-search-input type="input" onclick="this.select();" value="%{$searchs}" name="q">
                        <button data-search-clear><i class="p-search_clear_button fa-regular fa-circle-xmark"></i></button>
                    </div>

                </div>

                <div class="sort-control section">
                    <label for="sort-type">並び替え</label>
                    <select data-search-order class="sort-type" id="sort-type" name="sort-type">
                        <option value="0" {PPP:sort_type_select[0]}>作成日時 ▽</option>
                        <option value="1" {PPP:sort_type_select[1]}>作成日時 △</option>
                        <option value="2" {PPP:sort_type_select[2]}>更新日時 ▽</option>
                        <option value="3" {PPP:sort_type_select[3]}>更新日時 △</option>
                    </select>
                </div>
            </form>
            <div class="contents-area">
                {PPP IF:message}
                <div class="message-area">
                    {PPP:message}
                </div>
                {/PPP IF}
                <ul class="search-list">
                    {PPP LOOP:articles}
                    <li>
                        <div class="list-item log-link" data-log-link>
                            <a class='list-item-thumb log-link' href="{PPP:articles.url}">
                                <div class='list-item-thumb-in {PPP:articles.thumbnail_class}'>
                                    <img class='list-item-thumb-image' src="{ppp:articles.thumbnail_path}">
                                    <span class="list-item-thumb-title">{PPP:articles.thumbnail_title}</span>
                                </div>
                            </a>

                            <div class="list-item-created-at">{PPP:articles.created_at}</div>
                            <div class="list-item-title"><a href="{PPP:articles.url}">{PPP:articles.title}</a></div>
                            <div class="list-item-caption"><a href="{PPP:articles.url}">{PPP:articles.caption}</a></div>
                        </div>
                    </li>
                    {/PPP LOOP}
                </ul>
                {PPP INCLUDE:template2_parts_pagination.php}
            </div>
        </div>

        <div class="global-footer">
            {PPP:powered_info}
        </div>
    </div>
</body>

</html>