<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- meta -->
    {PPP INCLUDE:template2_meta_header.php}

    <!-- system header -->
    {PPP INCLUDE:template2_sys_header.php}

    <!-- template resouce -->
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/recss.css">
    <link rel="stylesheet" href="{PPP THEME_URL}/css/styles.css">
    <link rel="stylesheet" href="{PPP:site_url}/user_resource/user.css">
    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            document.querySelector('#conform_button').addEventListener("click", function() {
                location.replace("{PPP:redirect_url}")
            });

            document.querySelector("#cancel_button").addEventListener("click", function() {
                location.href = "{PPP:return_url}";
            });
        });
    </script>

    <style>
        header {
            padding: 1em;
        }

        .base {
            margin: 0 auto 0 auto;
            min-height: 100vh;
            max-width: 900px;
            background: linear-gradient(135deg, var(--bg-secondary) 0%, var(--bg-primary) 100%);
            border-radius: 15px;
            display: flex;
            justify-content: center;
            align-items: center;
            border: 2px solid var(--accent-cyan);
        }

        h1 {
            margin-bottom: 1em;
            text-align: center;
        }

        #contents_area {
            text-align: center;
            margin: 2em 0;
            color: var(--text-primary);
            line-height: 1.8;
        }

        #contents_area p {
            margin: 1em 0;
            font-size: 1.1em;
        }

        .button {
            margin: 1em;
            padding: 12px 28px;
            border: none;
            border-radius: 4px;
            font-size: 1em;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .button_force {
            background: linear-gradient(135deg, var(--accent-purple), var(--accent-cyan));
            color: #ffffff;
            width: auto;
            height: auto;
            min-width: 20em;
        }

        .button_force:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(0, 217, 255, 0.3);
        }

        .button_normal {
            background: var(--bg-secondary);
            border: 2px solid var(--accent-cyan);
            color: var(--accent-cyan);
            width: auto;
            height: auto;
            min-width: 15em;
        }

        .button_normal:hover {
            background: rgba(0, 217, 255, 0.1);
            box-shadow: 0 8px 24px rgba(0, 217, 255, 0.2);
        }
    </style>
</head>

<body>
    {PPP INCLUDE:template2_admin_header.php}
    <div class="base_wrapper">
        <div class="base">
            <div>
                <h1>{PPP:title}</h1>
                <div id="contents_area">
                    {PPP:contents}
                    <p>
                        {PPP IF:type == 0}
                        このサイトには18歳未満の方に不適切な表現が含まれます<br>
                        {PPP ELSE}
                        この記事には18歳未満の方に不適切な表現が含まれます<br>
                        {/PPP IF}
                    </p>
                    <p>
                        あなたは18歳以上ですか？
                    </p>
                </div>
                <div id="control">
                    <button id="conform_button" class="button button_force">18歳以上でNSFWコンテンツの閲覧に同意します</button><br>
                    <button id="cancel_button" class="button button_normal">{PPP:cancel_title}</button>
                </div>
            </div>
        </div>
    </div>
    <footer>{PPP:powered_info}</footer>
</body>

</html>