<style>
    @scope(.article-list-outline) {
        ul {
            list-style: none;
            padding-left: 0;
            color: var(--text-primary);
            width: 90%;
            margin: 0 auto;
        }

        ul a {
            text-decoration: none;
            color: var(--link-color);
            font-weight: 600;
            transition: all 0.3s ease;
        }

        ul a:hover {
            text-decoration: none;
            color: var(--accent-purple);
        }

        li {
            margin-bottom: 0.8rem;
            padding: 0.8rem;
            border-left: 3px solid var(--accent-cyan);
            border-radius: 4px;
            background: var(--bg-secondary);
            transition: all 0.3s ease;
        }

        li:hover {
            border-left-color: var(--accent-purple);
            box-shadow: 0 4px 12px rgba(0, 217, 255, 0.1);
            transform: translateX(5px);
        }

        .novel-outline-dot-line {
            flex-grow: 4;
            display: inline-block;
            height: 0.8em;
            border-bottom: 1px dotted var(--border-color);
            margin: 0 0.5em 0 0.5em;
            min-width: 2em;
        }

        .created_at {
            color: var(--text-secondary);
            font-size: 0.85em;
        }

        .title {
            color: var(--text-primary);
            font-weight: 600;
        }
    }
</style>
<div class="article-list-outline">
    <ul>
        {PPP LOOP:articles}
        <li class='text log-link'>
            <a href='{PPP:articles.url}' class="log-link" data-log-link>
                <div style='display:flex;'>
                    <span class='title'>{PPP:articles.title}</span>
                    <span class='novel-outline-dot-line'> </span>
                    <span class='created_at' style=" white-space: nowrap">{PPP:articles.created_at_day}</span>
                </div>
            </a>
        </li>
        {/PPP LOOP}
    </ul>
    {PPP INCLUDE:template2_parts_pagination.php}
</div>