<style>
    @scope(.article-list-normal) {
        li {
            list-style: none;
        }

        div.list-item {
            font-size: 1em;
            display: grid;
            grid-template-columns: 2em min-content 8em 3em auto;
            grid-template-rows: 1em 2em auto;
            margin: 0 3em 1em 3em;
            max-height: 150px;
            overflow: hidden;
            padding: 15px;
            background: var(--bg-secondary);
            border: 2px solid var(--border-color);
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        div.list-item:hover {
            border-color: var(--accent-cyan);
            background: rgba(26, 31, 58, 0.8);
            box-shadow: 0 8px 24px rgba(0, 217, 255, 0.1);
            transform: translateX(5px);
        }

        .list-item-thumb {
            grid-column: 2;
            grid-row: span 3;
            margin-right: 0.5em;
            width: var(--search-thumbnail-width, 100px);
            height: var(--search-thumbnail-height, 100px);
            background-color: var(--bg-tertiary);
            border: 2px solid var(--border-color);
            border-radius: 4px;
            overflow: hidden;
            background-size: cover;
            background-position: center center;
            transition: all 0.3s ease;
        }

        .list-item:hover .list-item-thumb {
            border-color: var(--accent-cyan);
            box-shadow: 0 0 15px rgba(0, 217, 255, 0.2);
        }

        .list-item-thumb-in {
            position: relative;
            width: var(--search-thumbnail-width, 100px);
            height: var(--search-thumbnail-height, 100px);
        }

        .list-item-created-at {
            text-wrap: nowrap;
            grid-column: 3;
            font-size: 0.7em;
            margin-right: 1em;
            color: var(--text-secondary);
        }

        .list-item-views {
            grid-column: 4;
            font-size: 0.7em;
            text-wrap: nowrap;
            min-width: 3em;
            color: var(--text-secondary);
        }

        .list-item-like {
            grid-column: 5;
            font-size: 0.7em;
            text-wrap: nowrap;
            min-width: 3em;
            color: var(--text-secondary);
        }

        .list-item-title {
            align-self: center;
            grid-column: 3 / span 3;
            text-wrap: nowrap;
            line-height: 160%;
            text-overflow: ellipsis;
            font-weight: 600;
            color: var(--text-primary);
        }

        .list-item-title a {
            color: var(--link-color);
            font-weight: 600;
        }

        .list-item-title a:hover {
            color: var(--accent-purple);
        }

        .list-item-caption {
            grid-column: 3 / span 3;
            font-size: 0.8em;
            overflow: hidden;
            line-height: 140%;
            max-height: var(--search-thumbnail-height, 100px);
            text-overflow: ellipsis;
            color: var(--text-secondary);
        }

        .list-item-caption a {
            color: var(--text-secondary);
        }

        .list-item-caption a:hover {
            color: var(--link-color);
        }

        .list-item-thumb-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            object-position: center;
            transition: filter 0.3s ease;
        }

        .list-item:hover .list-item-thumb-image {
            filter: brightness(1.1) contrast(1.05);
        }

        .list-item-thumb-title {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: grid;
            place-content: center;
            background: rgba(10, 14, 39, 0.6);
            color: var(--accent-cyan);
            font-weight: 600;
            border-radius: 4px;
        }
    }
</style>
<div class="article-list article-list-normal">
    <ul>
        {PPP LOOP:articles}
        <li>
            <div class="list-item log-link" data-log-link>
                <a class='list-item-thumb log-link' href="{PPP:articles.url}">
                    <div class='list-item-thumb-in {PPP:articles.thumbnail_class}'>
                        <img class='list-item-thumb-image' src="{ppp:articles.thumbnail_path}">
                        <span class="list-item-thumb-title">{PPP:articles.thumbnail_title}</span>
                    </div>
                </a>

                <div class="list-item-created-at">{PPP:articles.created_at}</div>
                <div class="list-item-title"><a href="{PPP:articles.url}">{PPP:articles.title}</a></div>
                <div class="list-item-caption"><a href="{PPP:articles.url}">{PPP:articles.caption}</a></div>
            </div>
        </li>
        {/PPP LOOP}
    </ul>
    {PPP INCLUDE:template2_parts_pagination.php}
</div>