<style>
    .diary-list {
        width: 90%;
        margin: 0 auto;
    }

    @scope(.diary-list) {
        .day {
            display: flex;
            flex-direction: column;
            align-items: left;
            border-bottom: 1px solid var(--border-color);
            padding: 1.5rem;
            margin-bottom: 1rem;
            background: var(--bg-secondary);
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .day:hover {
            border-bottom-color: var(--accent-cyan);
            box-shadow: 0 8px 24px rgba(0, 217, 255, 0.1);
        }

        .created-at {
            font-size: 0.85rem;
            color: var(--text-secondary);
            margin-bottom: 0.5rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .contents {
            min-height: 3rem;
            color: var(--text-primary);
            margin-bottom: 1rem;
            line-height: 1.6;
        }

        .images {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }

        .thumbnail {
            width: 100px;
            height: 100px;
            overflow: hidden;
            border: 2px solid var(--border-color);
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .thumbnail:hover {
            border-color: var(--accent-cyan);
            box-shadow: 0 0 15px rgba(0, 217, 255, 0.2);
            transform: scale(1.05);
        }

        .thumbnail img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            aspect-ratio: 1/1;
            transition: filter 0.3s ease;
        }

        .thumbnail:hover img {
            filter: brightness(1.1);
        }

        .thumbnail a {
            display: block;
            width: 100%;
            height: 100%;
        }
    }
</style>
<div class="diary-list">
    {PPP LOOP:articles}
    <section class="day">
        <span class="created-at">{PPP:articles.created_at[Y年m月d日]}</span>
        <div class="contents">{PPP:articles.contents}</div>
        {PPP IF:articles.media_count}
        <section class="images">
            {PPP LOOP:articles.media}
            <div class="thumbnail">
                <a href="{PPP:article.url}" data-thumbnail><img src="{PPP SITE_URL}/images/{PPP:media.thumb_name}" data-src="{PPP SITE_URL}/images/{PPP:media.sub_dir}{PPP:media.file_name}" width="150" data-width="{PPP:media.width}" data-height="{PPP:media.height}" alt="{PPP:media.comment}"></a>
            </div>
            {/PPP LOOP}
        </section>
        {/PPP IF}
    </section>
    {/PPP LOOP}
    {PPP INCLUDE:template2_parts_pagination.php}
</div>
