<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- meta -->
    {PPP INCLUDE:template2_meta_header.php}

    <!-- system header -->
    {PPP INCLUDE:template2_sys_header.php}

    <!-- template resouce -->
    <link rel="stylesheet" href="{PPP SITE_URL}/system_resource/css/recss.css">
    <link rel="stylesheet" href="{PPP THEME_URL}/css/styles.css">
    <link rel="stylesheet" href="{PPP:site_url}/user_resource/user.css">

    <style>
        .article_container {
            max-width: 900px;
            margin-top: 2rem;
            margin-bottom: 2rem;
            border-radius: 15px;
        }

        .section {
            margin-bottom: 1rem;
        }

        .tag {
            font-size: 0.8rem;
        }

        .global-header {
            margin-left: 0.5rem;
        }

        .header {
            margin-left: 0.5rem;
        }

        .control {
            text-align: center;
        }

        .move_control {
            display: grid;
            grid-template-columns: minmax(0, 1fr) auto minmax(0, 1fr);
            align-items: center;
            column-gap: 0.5em;
        }

        .move_prev {
            text-align: left;
            padding-left: 0.5em;
            justify-self: start;
        }

        .move_next {
            text-align: right;
            padding-right: 0.5em;
            justify-self: end;
        }

        .move_separator {
            text-align: center;
        }

        .move_control span {
            display: block;
            width: 100%;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
</head>

<body>
    {PPP INCLUDE:template2_admin_header.php}
    <div class="global-header">
        <a href="./">
            {PPP:site_title}
        </a>
    </div>
    <div class="header">
        <a href="" data-log-return>
            &lt; 戻る
        </a>
    </div>
    <div class="main-container article_container">
        <div class="main-contents">
            <div class="section title">
                <h1>{PPP:title}</h1>
            </div>
            <div class="section caption">{PPP:caption}</div>
            <div class="section tag">{PPP:tag_links_html}</div>
            <div class="section created-at">{PPP:created_at}</div>
            <div class="section contents">
                {PPP:contents}
                {PPP IF:simple_mode}
                {PPP LOOP:media}
                {PPP:media.thumbnail_html}
                {/PPP LOOP}
                {/PPP IF}
            </div>

            <div class="control">
                {PPP IF:settings['use_feedback']}
                {PPP IF:settings['show_likes']}{PPP IF:likes}
                <div class="section"><i id="like-heart" class="fa-regular fa-heart"></i> {PPP:likes}</div>
                {/PPP IF}{/PPP IF}
                <div class="section"><span class="p-button-like-it" data-like-it>いいね！</span></div>
                {PPP IF:settings['show_share_button']}
                <div class="section"><a href="https://twitter.com/share?ref_src=twsrc%5Etfw" target="_blank" class="twitter-share-button" data-show-count="false">Tweet</a></div>
                <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
                {/PPP IF}
                {/PPP IF}

                {PPP IF:settings['move_link_type'] != 0}
                <div class="section move_control">
                    <span class="move_next">{PPP:next_link_html}</span><span class="move_separator"> | </span><span class="move_prev">{PPP:prev_link_html}</span>
                </div>
                {/PPP IF}
                {PPP:csrf}
                <button id="return-button" class="p-button p-button-normal" data-log-return>戻る</button>
            </div>
        </div>
        <div class="global-footer">
            {PPP:powered_info}
        </div>
    </div>
</body>

</html>