<?php

//Parsedownの出力するタグにclass="md"を付与する
class ParsedownEx extends Parsedown
{
    protected function elements(array $Elements)
    {
        $markup = '';

        $auto_break = true;

        foreach ($Elements as $Element) {
            if (empty($Element)) {
                continue;
            }

            if (isset($Element['attributes'])) {
                if (isset($Element['attributes']['class'])) {
                    $Element['attributes']['class'] = $Element['attributes']['class'] . ' md';
                } else {
                    $Element['attributes']['class'] = 'md';
                }
            } else {
                $Element['attributes'] = array('class' => 'md');
            }

            $auto_break_next = (
                isset($Element['autobreak'])
                ? $Element['autobreak'] : isset($Element['name'])
            );
            // (autobreak === false) covers both sides of an element
            $auto_break = !$auto_break ? $auto_break : $auto_break_next;

            $markup .= ($auto_break ? "\n" : '') . $this->element($Element);
            $auto_break = $auto_break_next;
        }

        $markup .= $auto_break ? "\n" : '';

        return $markup;
    }
}
