<?php
class AtomFeed
{
    protected $dom;
    protected $root;

    public function __construct($attributes = array())
    {
        $dom = new \DOMDocument('1.0', 'UTF-8');
        $dom->preserve_white_space = false;
        $dom->format_output = true;
        $this->dom = $dom;
        $root = $dom->createElement('feed');
        $this->root = $root;
        $dom->appendChild($root);
        $root->setAttribute('xmlns', 'http://www.w3.org/2005/Atom');
        foreach ($attributes as $key => $value) {
            $root->setAttribute($key, $value);
        }
    }

    public function save($filename)
    {
        return $this->dom->save($filename);
    }

    public function saveXML()
    {
        return $this->dom->saveXML();
    }

    public function title($value, $type = 'text')
    {
        $title = $this->root->appendChild($this->dom->createElement('title'));
        $title->appendChild($this->dom->createCDATASection($value));
        $title->setAttribute('type', $type);
    }

    /*
    public function subtitle($value, $type = 'text')
    {
        $subtitle = $root->appendChild($dom->createElement('subtitle'));
        $subtitle->appendChild($dom->createCDATASection($value));
        $subtitle->setAttribute('type', $type);
    }*/

    public function link($href, $rel = null, $type = null, $title = null, $length = null)
    {
        $link = $this->root->appendChild($this->dom->createElement('link'));
        $link->setAttribute('href', $href);
        if ($type) {
            $link->setAttribute('type', $type);
        }
        if ($rel) {
            $link->setAttribute('rel', $rel);
        }
        if ($title) {
            $link->setAttribute('title', $title);
        }
        if ($length) {
            $link->setAttribute('length', $length);
        }
    }

    public function updated($value)
    {
        $date = new \DateTime($value);
        $this->root->appendChild(
            $this->dom->createElement('updated', $date->format(\DateTime::RFC3339))
        );
    }

    public function id($value)
    {
        $this->root->appendChild($this->dom->createElement('id', $value));
    }

    public function author($params)
    {
        $author = $this->dom->createElement('author');
        foreach ($params as $key => $value) {
            $author->appendChild($this->dom->createElement($key, $value));
        }
        $this->root->appendChild($author);
    }

    public function rights($value, $type = 'html')
    {
        $rights = $this->root->appendChild($this->dom->createElement('rights'));
        $rights->appendChild($this->dom->createCDATASection($value));
        $rights->setAttribute('rights', $rights);
    }

    public function generator($value, $uri = null, $version = null)
    {
        $generator = $this->root->appendChild(
            $this->dom->createElement('generator', $value)
        );
        if ($uri) {
            $generator->setAttribute('uri', $uri);
        }
        if ($version) {
            $generator->setAttribute('version', $version);
        }
    }

    public function addCustomElement($name, $value, $attributes = array(), $cdata = false)
    {
        $elem = $this->dom->createElement($name);
        foreach ($attributes as $key => $value) {
            $elem->setAttribute($key, $value);
        }

        if ($cdata) {
            $cdata = $this->dom->createCDATASection($value);
            $elem->appendChild($cdata);
        } else {
            $elem->node_value = $value;
        }

        $this->root->appendChild($elem);
    }

    public function addEntry($entry)
    {
        $node = $this->dom->createElement('entry');
        $this->root->appendChild($node);

        $params = $entry->all();
        foreach ($params as $param) {
            $element = $this->dom->createElement($param['name']);
            $node->appendChild($element);

            if (isset($param['value']) && !is_null($param['value'])) {
                if (isset($param['cdata']) && $param['cdata'] === true) {
                    $cdata = $this->dom->createCDATASection($param['value']);
                    $element->appendChild($cdata);
                } else {
                    $text_node = $this->dom->createTextNode($param['value']);
                    $element->appendChild($text_node);
                }
            }

            if (isset($param['attributes'])) {
                foreach ($param['attributes'] as $attr_key => $attr_value) {
                    if (is_null($attr_value)) {
                        continue;
                    }
                    $element->setAttribute($attr_key, $attr_value);
                }
            }

            if (isset($param['values']) && is_array($param['values'])) {
                foreach ($param['values'] as $key2 => $param2) {
                    $child = $this->dom->createElement($key2);
                    $element->appendChild($child);

                    if (isset($param2['value']) && !is_null($param2['value'])) {
                        if (isset($param2['cdata']) && $param2['cdata'] === true) {
                            $cdata = $this->dom->createCDATASection($param2['value']);
                            $child->appendChild($cdata);
                        } else {
                            $text_node = $this->dom->createTextNode($param2['value']);
                            $child->appendChild($text_node);
                        }
                    }

                    if (isset($param2['attributes'])) {
                        foreach ($param2['attributes'] as $attr_key => $attr_value) {
                            if (is_null($attr_value)) {
                                continue;
                            }
                            $child->setAttribute($attr_key, $attr_value);
                        }
                    }
                }
            }
        }
    }
}
