/**
 * Console2 Messages Modal JavaScript
 * メッセージ詳細モーダル専用のスクリプト
 */

var ConsoleMessagesModal = (function () {
    'use strict';

    // プライベート変数
    var modal = null;
    var closeBtn = null;

    /**
     * モーダルを開く
     * @param {Object} data - メッセージデータ
     */
    function openModal(data) {
        if (!modal) return;

        document.getElementById('detailName').textContent = data.name || '-';
        document.getElementById('detailEmail').innerHTML = '<a href="' + data.email + '">' + data.email + '</a>' || '-';
        document.getElementById('detailIP').textContent = data.ip || '-';
        document.getElementById('detailDate').textContent = data.date || '-';
        document.getElementById('detailMessage').innerHTML = data.message || '-';

        modal.classList.add('active');
        document.body.style.overflow = 'hidden';

        // 既読APIを呼ぶ
        if (data.id) {
            markAsRead(data.id);
        }
    }

    /**
     * メッセージを既読にする
     * @param {string} messageId - メッセージID
     */
    function markAsRead(messageId) {
        fetch(BASE_URL + '/api/v2/messages/' + messageId + '/read', {
            method: 'POST'
        })
            .then(function (response) {
                if (response.ok) {
                    // メッセージアイテムのクラスを更新
                    var messageItem = document.querySelector('.message-item[data-id="' + messageId + '"]');
                    if (messageItem) {
                        messageItem.classList.remove('unread');
                        messageItem.classList.add('read');
                    }
                }
            })
            .catch(function (err) {
                console.error('既読処理でエラーが発生しました:', err);
            });
    }

    /**
     * モーダルを閉じる
     */
    function closeModal() {
        if (!modal) return;

        modal.classList.remove('active');
        document.body.style.overflow = '';
    }

    /**
     * 表示ボタンのイベントを設定
     */
    function setupViewButtons() {
        document.querySelectorAll('.view-message').forEach(function (btn) {
            btn.addEventListener('click', function () {
                openModal({
                    id: this.getAttribute('data-id'),
                    name: this.getAttribute('data-name'),
                    email: this.getAttribute('data-email'),
                    ip: this.getAttribute('data-ip'),
                    date: this.getAttribute('data-date'),
                    message: this.getAttribute('data-message')
                });
            });
        });
    }

    /**
     * イベントリスナーを設定
     */
    function setupEventListeners() {
        // 閉じるボタン
        if (closeBtn) {
            closeBtn.addEventListener('click', closeModal);
        }

        // モーダル背景クリック
        if (modal) {
            modal.addEventListener('click', function (e) {
                if (e.target === modal) {
                    closeModal();
                }
            });
        }

        // ESCキーで閉じる
        document.addEventListener('keydown', function (e) {
            if (e.key === 'Escape' && modal && modal.classList.contains('active')) {
                closeModal();
            }
        });

        // 表示ボタン
        setupViewButtons();
    }

    /**
     * 初期化
     */
    function init() {
        modal = document.getElementById('messageDetailModal');
        closeBtn = document.getElementById('closeModal');

        setupEventListeners();
    }

    // 公開API
    return {
        init: init,
        openModal: openModal,
        closeModal: closeModal
    };
})();

// DOMContentLoadedで初期化
document.addEventListener('DOMContentLoaded', function () {
    ConsoleMessagesModal.init();
});
