/**
 * Console2 Dashboard JavaScript
 * ダッシュボード画面専用のスクリプト
 */

var ConsoleDashboard = (function () {
    'use strict';

    // プライベート変数
    var searchInput = null;
    var draftsTable = null;
    var noDraftsEl = null;

    /**
     * 下書き検索を実行
     * @param {string} query - 検索クエリ
     */
    function searchDrafts(query) {
        var q = query.toLowerCase();
        var rows = draftsTable ? draftsTable.querySelectorAll('tr') : [];
        var hasVisible = false;

        for (var i = 0; i < rows.length; i++) {
            var titleCell = rows[i].querySelector('.table-title');
            if (titleCell) {
                var title = titleCell.textContent.toLowerCase();
                if (title.indexOf(q) !== -1) {
                    rows[i].style.display = '';
                    hasVisible = true;
                } else {
                    rows[i].style.display = 'none';
                }
            }
        }

        if (noDraftsEl) {
            noDraftsEl.style.display = hasVisible ? 'none' : 'block';
        }
    }

    /**
     * イベントリスナーを設定
     */
    function setupEventListeners() {
        // 下書き検索
        if (searchInput) {
            searchInput.addEventListener('input', function (e) {
                searchDrafts(e.target.value.trim());
            });
        }
    }

    /**
     * 初期化
     */
    function init() {
        // 要素の取得
        searchInput = document.getElementById('search-drafts');
        draftsTable = document.getElementById('drafts-table');
        noDraftsEl = document.getElementById('no-drafts');

        // イベントリスナーを設定
        setupEventListeners();
    }

    // 公開API
    return {
        init: init,
        searchDrafts: searchDrafts
    };
})();

// DOMContentLoadedで初期化
document.addEventListener('DOMContentLoaded', function () {
    ConsoleDashboard.init();
});
