document.addEventListener("DOMContentLoaded", async () => {
    //イベント登録
    Q(".button_submit").addEventListener("click", async () => {
        saveCss();
    });

    Q(".button_reset").addEventListener("click", async () => {
        //TODO:CSS初期化処理
        //resetCss();
    });
});

async function saveCss(){
    try{
        var ret = await async_saveCss();
        await windows.showDialog("保存しました","OK");
    }
    catch{
        await windows.showDialog("保存に失敗しました","OK");
    }
}

// 非同期記事送信本体
async function async_saveCss() {

    let url = `${BASE_URL}/setting/css`;
    let method = "POST";
    let formData = new FormData();
    formData.append('csrf_token', document.getElementById("csrf_token").value);
    formData.append('encode', 'base64');
    const comment = Q("#css").value;
    const utf8Bytes = new TextEncoder().encode(comment);
    const base64String = btoa(String.fromCharCode(...utf8Bytes));
    formData.set("css", base64String);

    try {
        const response = await fetch(url, {
            method: method,
            body: formData
        });
        if (!response.ok) {
            throw new Error("Network response was not ok");
        }

        return await response.json();
    } catch (error) {
        console.error("Error:", error);
        throw error;
    }
}