/**
 * Console2 Common JavaScript
 * 3つのコンソール画面（ダッシュボード、記事一覧、メッセージ）で共通のスクリプト
 */

var ConsoleCommon = (function() {
    'use strict';

    // プライベート変数
    var sidebar = null;
    var content = null;
    var toggleBtn = null;
    var mobileMenuBtn = null;
    var sidebarOverlay = null;

    /**
     * モバイルメニューを開く
     */
    function openMobileMenu() {
        if (sidebar) sidebar.classList.add("show");
        if (sidebarOverlay) sidebarOverlay.classList.add("active");
        if (mobileMenuBtn) {
            mobileMenuBtn.classList.add("active");
            var icon = mobileMenuBtn.querySelector("i");
            if (icon) icon.className = "bi bi-x-lg";
        }
        if (toggleBtn) {
            var toggleIcon = toggleBtn.querySelector("i");
            if (toggleIcon) toggleIcon.className = "bi bi-x-lg";
        }
        document.body.style.overflow = "hidden";
    }

    /**
     * モバイルメニューを閉じる
     */
    function closeMobileMenu() {
        if (sidebar) sidebar.classList.remove("show");
        if (sidebarOverlay) sidebarOverlay.classList.remove("active");
        if (mobileMenuBtn) {
            mobileMenuBtn.classList.remove("active");
            var icon = mobileMenuBtn.querySelector("i");
            if (icon) icon.className = "bi bi-list";
        }
        if (toggleBtn) {
            var toggleIcon = toggleBtn.querySelector("i");
            if (toggleIcon) toggleIcon.className = "bi bi-list";
        }
        document.body.style.overflow = "";
    }

    /**
     * モバイルメニューをトグル
     */
    function toggleMobileMenu() {
        if (sidebar && sidebar.classList.contains("show")) {
            closeMobileMenu();
        } else {
            openMobileMenu();
        }
    }

    /**
     * イベントリスナーを設定
     */
    function setupEventListeners() {
        // サイドバートグル（デスクトップ）
        if (toggleBtn) {
            toggleBtn.addEventListener("click", function(e) {
                e.preventDefault();
                if (window.innerWidth <= 768) {
                    closeMobileMenu();
                } else {
                    if (sidebar) sidebar.classList.toggle("collapsed");
                    if (content) content.classList.toggle("expanded");
                }
            });
        }

        // モバイルメニューボタン
        if (mobileMenuBtn) {
            mobileMenuBtn.addEventListener("click", function(e) {
                e.preventDefault();
                toggleMobileMenu();
            });
        }

        // オーバーレイクリック
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener("click", function(e) {
                e.preventDefault();
                closeMobileMenu();
            });
        }

        // ウィンドウリサイズ時の処理
        window.addEventListener("resize", function() {
            if (window.innerWidth > 768) {
                closeMobileMenu();
            }
        });
    }

    /**
     * 初期化
     */
    function init() {
        // 要素の取得
        sidebar = document.getElementById("sidebar");
        content = document.getElementById("content");
        toggleBtn = document.getElementById("toggleSidebar");
        mobileMenuBtn = document.getElementById("mobileMenuBtn");
        sidebarOverlay = document.getElementById("sidebarOverlay");

        // イベントリスナーを設定
        setupEventListeners();
    }

    // 公開API
    return {
        init: init,
        openMobileMenu: openMobileMenu,
        closeMobileMenu: closeMobileMenu,
        toggleMobileMenu: toggleMobileMenu
    };
})();

// DOMContentLoadedで初期化
document.addEventListener('DOMContentLoaded', function() {
    ConsoleCommon.init();

    // Scroll Header Script
    var contentHeader = document.querySelector('.content-header');
    if (contentHeader) {
        window.addEventListener('scroll', function() {
            if (window.scrollY > 50) {
                contentHeader.classList.add('scrolled');
            } else {
                contentHeader.classList.remove('scrolled');
            }
        });
    }
});
