

function searchExec() {
  if ($('#search').val() != "検索...") {
    location.href = '?q=' + $('#search').val() + '&sort_type=' + $('#sort_type').val();
  }
}

async function deleteExec() {
  var targets = $('.delete_check:checked');
  if (targets.length == 0) {
    //チェックのついてる物がない
    await showDialog("対象を選択してください", "OK");
    return;
  }
  var ret = await showDialog("選択されたログを削除していいですか？<br>※画像も削除されます", "OK", "キャンセル");
  if (ret != "OK") {
    console.log("cancel");
    return;
  }
  var wait = $('base').waitDialog("処理中…");
  targets.each(async function () {
    await deleteLog($(this).data('id'));
  });
  await new Promise((resolve) => setTimeout(resolve, 500));
  wait.close();
  location.reload();

}

//非同期削除処理本体
async function deleteLog(id) {
  return new Promise((resolve, reject) => {
    $.ajax({
      type: 'POST',
      url: './api/article_delete.php',
      data: { "target": id },
      success: function (response) {
        console.log('Success: ' + response);
        var result = JSON.parse(response);
        resolve(result)
      },
      error: function () {
        reject();
      }
    });
  });
}

//非同期通知取得
async function getActivity(target) {

  if (target == "") {
    send_data = { "target": "like", "format": "html", "no_read_only": "true" };
  }
  else {
    send_data = { "target": "like", "format": "html" };
  }

  return new Promise((resolve, reject) => {
    $.ajax({
      type: 'GET',
      url: rel + 'api/activity.php',
      data: send_data,
      success: function (response) {
        var result = response;
        resolve(result)
      },
      error: function () {
        reject();
      }
    });
  });
}

//非同期通知既読化
async function setActivityReadFlag() {
  return new Promise((resolve, reject) => {
    $.ajax({
      type: 'GET',
      url: rel + 'api/activity.php',
      data: { "action": "readed" },
      success: function (response) {
        var result = response;
        resolve(result)
      },
      error: function () {
        reject();
      }
    });
  });
}

//通知保持用
activity = "";

$(async function () {
  if (typeof (rel) == "undefined") {
    rel = "./";
  }

  $('#search').on('keydown', function (e) {
    if (e.keyCode == 13) {
      e.preventDefault();
      searchExec();
    }
  });
  $("#sort_type").on("change", function (e) {
    e.preventDefault();
    searchExec();
  });
  activity = await getActivity("");
  if (activity != "") {
    $('#notification').removeClass("fa-regular");
    $('#notification').addClass("fa-solid");
    $("#notification-link").css("color", "#cc0000");
  }
  else {
    activity = await getActivity("old");
    $("#notification-link").css("color", "#888888");
  }

  $('#notification').on('click', async function () {
    await showDialog("<p class='notification-msg'>" + activity + "</p>");
    await setActivityReadFlag();
    $('#notification').removeClass("fa-solid");
    $('#notification').addClass("fa-regular");
    $("#notification-link").css("color", "#888888");
  });

  $(".search_word").on("click", function () {
    tag = $(this).data("search");
    location.href = "./console.php?q=" + encodeURI(tag);
  });

  $("#console_tag_cloud .tag").on("click", function () {
    tag = $(this).text().slice(1);
    location.href = "./console.php?q=%23" + encodeURI(tag);
  });

  $("#console_tag_cloud .tag_cloud_more_link").on("click", function (e) {
    $(".tag-cloud-more").toggle(300);
  });

});

