window.Q = function (selector) {
    return document.querySelector(selector);
};

window.QA = function (selector) {
    return document.querySelectorAll(selector);
};

window.showDialog = async function (message, title = null, ok_button = null, cancel_button = null) {
    let dialog = new PppDialog();
    await dialog.showDialog(message, title, ok_button, cancel_button);
}

// 汎用イベント設定
document.addEventListener("DOMContentLoaded", async () => {

    /* return_button */
    document.querySelectorAll("[data-log-return]").forEach(btn => {
        btn.addEventListener("click", (e) => {
            e.preventDefault();
            let url = getHistory();
            if (!url) {
                url = SITE_URL;
            }
            window.location.href = url;
        });
    });

    /* alertを閉じる */
    document.querySelectorAll("[data-alert-close]").forEach(btn => {
        btn.addEventListener("click", (e) => {
            document.querySelector('.alert').classList.add('hide');
        });
    });

    /* log_link */
    document.querySelectorAll("[data-log-link]").forEach(link => {
        link.addEventListener("click", () => {
            writeHistory();
        });
    });

    /* like_button */
    document.querySelectorAll("[data-like-it]").forEach(link => {
        link.addEventListener("click", (e) => {
            e.preventDefault();
            addLike(e.target);
        });
    });

    /* more_button */
    document.querySelectorAll("[data-more]").forEach(btn => {
        btn.addEventListener("click", () => {

            // 直前の .more_area を取得
            const target = btn.previousElementSibling;
            if (!target || !target.hasAttribute('data-more-area')) {
                return; // 対象がなければ何もしない
            }

            const openLabel = btn.dataset.label || "";
            const closeLabel = btn.dataset.closelabel || "";

            const isVisible = target.offsetParent !== null;

            if (isVisible) {
                btn.textContent = openLabel;
                btn.classList.add("p-more-button-active");
            } else {
                btn.textContent = closeLabel;
                btn.classList.remove("p-more-button-active");
            }

            slideToggle(target, 200);
        });
    });

    /* search_button */
    document.querySelectorAll("[data-search]").forEach(btn => {
        btn.addEventListener("change", (e) => {
            e.preventDefault();
            searchExec();
        });
    });
    document.querySelectorAll("[data-search-order]").forEach(btn => {
        btn.addEventListener("change", (e) => {
            searchExec();
        });
    });
    document.querySelectorAll("[data-search-clear]").forEach(btn => {
        btn.addEventListener("click", (e) => {
            e.preventDefault();
            document.querySelector("[data-search-input").value = "";
        });
    });

    updateHistory();

});

//検索実行
function searchExec() {
    location.href = `${BASE_URL}/search?q=` + encodeURIComponent(Q('[data-search-input]').value) + '&sort_type=' + Q('[data-search-order]').value;
}

//続きを読む展開処理
function slideToggle(element, duration = 200) {
    if (!element) return;

    const isHidden = window.getComputedStyle(element).display === "none";

    element.style.overflow = "hidden";
    element.style.transition = `max-height ${duration}ms ease`;

    if (isHidden) {
        element.style.display = "block";
        const height = element.scrollHeight + "px";
        element.style.maxHeight = "0px";
        requestAnimationFrame(() => {
            element.style.maxHeight = height;
        });
    } else {
        element.style.maxHeight = "0px";
        setTimeout(() => {
            element.style.display = "none";
        }, duration);
    }
}

//「いいね」ボタン
async function addLike(element) {

    //いいねボタン状態変化
    if (element.classList.contains("p-button-like-it")) {
        element.classList.add("p-button-like-it-active");
    }

    const csrf = document.querySelector('input[name="csrf_token"]')?.value || "";
    const url = `${BASE_URL}/api/v2/articles/${ARTICLE_ID}/like`;
    const method = "POST";
    const data = new FormData();
    data.append("url", location.href);
    data.append("csrf_token", csrf);

    try {
        const response = await fetch(url, {
            method: method,
            body: data
        });
        const textResponse = await response.text();
        console.log(textResponse);
        if (!response.ok) {
            throw new Error("Network response was not ok");
        }
        return JSON.parse(textResponse);
    } catch (error) {
        console.error("Error:", error);
        throw error;
    }
}

//「戻る」リンクの履歴クリア
function clearHistory() {
    sessionStorage.setItem("back_url", "[]");
}

function updateHistory() {

    let json = sessionStorage.getItem("back_url");
    if (json == null || json == "" || json == "[]") {
        return;
    }
    try {
        const back_history = JSON.parse(json);
        const back_url = back_history.at(-1);
        console.log("from " + back_url);
        if (back_url == location.href) {
            back_history.pop();
            sessionStorage.setItem("back_url", JSON.stringify(back_history));
        }
    }
    catch {
        //Historyデータが壊れている？
        return;
    }

}

//「戻る」リンクの戻り先記録
function writeHistory() {
    let json = sessionStorage.getItem("back_url");
    if (json == null || json == "" || json == "[]" || json == "{}") {
        json = "[]";
    }

    try {
        back_history = JSON.parse(json);
        back_history.push(location.href);
    }
    catch {
        back_history = [];
        back_history.push(location.href);
    }
    sessionStorage.setItem("back_url", JSON.stringify(back_history));
}

//「戻る」リンクの戻り先取得
function getHistory() {
    let json = sessionStorage.getItem("back_url");
    if (json == null || json == "" || json == "[]") {
        return "";
    }
    try {
        const back_history = JSON.parse(json);
        return back_history.at(-1);
    }
    catch {
        return "";
    }

}

// Cookieに値を保存する関数
function setCookie(name, value) {
    document.cookie = name + "=" + value + "; expires=; path=/";
}

// Cookieから値を読み込む関数
function getCookie(name) {
    var cookies = document.cookie.split(";");
    for (var i = 0; i < cookies.length; i++) {
        var cookie = cookies[i].trim();
        if (cookie.indexOf(name + "=") === 0) {
            return cookie.substring(name.length + 1, cookie.length);
        }
    }
    return null;
}


//縦書きのスクロールを滑らかにする
var scrollDistance = 1; // スクロールする距離(ピクセル単位)
var scrollSpeed = 30; // スクロールする速度(ミリ秒単位)
var scrollTimeout = null; // スクロールタイムアウト
var scrollValue = 0;
var scrollCount = 0;

// スムーズスクロール用のアニメーション関数
function smoothScrollTo(element, targetScrollLeft, duration) {
    const startScrollLeft = element.scrollLeft;
    const distance = targetScrollLeft - startScrollLeft;
    const startTime = performance.now();

    function animation(currentTime) {
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);

        // easeOutQuad イージング
        const easeProgress = progress * (2 - progress);

        element.scrollLeft = startScrollLeft + (distance * easeProgress);

        if (progress < 1) {
            requestAnimationFrame(animation);
        }
    }

    requestAnimationFrame(animation);
}

document.querySelectorAll(".p-novel-body").forEach(novelBody => {
    novelBody.addEventListener("wheel", async function (event) {
        if (!this.classList.contains("p-vertical-text")) {
            return;
        }
        // スクロールイベントが発生したら、一定時間保留してスクロール処理を実行する
        event.preventDefault();
        var delta = event.deltaY;
        scrollValue += (delta * scrollDistance);
        scrollCount++;
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(function () {
            const verticalText = document.querySelector(".p-vertical_text");
            if (verticalText) {
                var scrollLeft = verticalText.scrollLeft;
                smoothScrollTo(verticalText, scrollLeft - scrollValue, scrollCount * 10);
                scrollValue = 0;
                scrollCount = 0;
            }
        }, 5);
    });

    // Firefox用のDOMMouseScrollイベント
    novelBody.addEventListener("DOMMouseScroll", async function (event) {
        if (!this.classList.contains("p-vertical-text")) {
            return;
        }
        // スクロールイベントが発生したら、一定時間保留してスクロール処理を実行する(Firefox用)
        event.preventDefault();
        var scrollAmount = event.detail * 10;
        scrollValue += scrollAmount;
        scrollCount++;
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(function () {
            const verticalText = document.querySelector(".p-vertical-text");
            if (verticalText) {
                var scrollLeft = verticalText.scrollLeft;
                smoothScrollTo(verticalText, scrollLeft - scrollValue, scrollCount * 10);
                scrollValue = 0;
                scrollCount = 0;
            }
        }, 5);
    });
});

document.querySelectorAll(".p-vt-controler-1").forEach(btn => {
    btn.addEventListener("click", function () {
        setFontSize1();
        setCookie("novel-font-size", "1");
    });
});

document.querySelectorAll(".p-vt-controler-2").forEach(btn => {
    btn.addEventListener("click", function () {
        setFontSize2();
        setCookie("novel-font-size", "2");
    });
});

document.querySelectorAll(".p-vt-controler-3").forEach(btn => {
    btn.addEventListener("click", function () {
        setFontSize3();
        setCookie("novel-font-size", "3");
    });
});

document.querySelectorAll(".p-vt-controler-h").forEach(btn => {
    btn.addEventListener("click", function () {
        setHorizontal();
        setCookie("novel-text-block", "h");
    });
});

document.querySelectorAll(".p-vt-controler-v").forEach(btn => {
    btn.addEventListener("click", function () {
        setVertical();
        setCookie("novel-text-block", "v");
    });
});

document.querySelectorAll(".p-vt-controler-fs").forEach(btn => {
    btn.addEventListener("click", function () {
        setFontSerif();
        setCookie("novel-text-font", "s");
    });
});

document.querySelectorAll(".p-vt-controler-fss").forEach(btn => {
    btn.addEventListener("click", function () {
        setFontSansSerif();
        setCookie("novel-text-font", "ss");
    });
});

document.querySelectorAll(".p-vt-controler-ctl").forEach(btn => {
    btn.addEventListener("click", function () {
        document.querySelectorAll(".p-vt-controler").forEach(el => el.classList.toggle("hide"));
        document.querySelectorAll(".p-vt-cover").forEach(el => el.classList.toggle("hide"));
    });
});

document.querySelectorAll(".p-vt-cover").forEach(cover => {
    cover.addEventListener("click", function () {
        document.querySelectorAll(".p-vt-controler").forEach(el => el.classList.toggle("hide"));
        document.querySelectorAll(".p-vt-cover").forEach(el => el.classList.toggle("hide"));
    });
});

function setFontSize1() {
    document.querySelectorAll(".p-novel-body-in").forEach(el => el.style.fontSize = "1em");
    document.querySelectorAll(".p-vt-controler-1").forEach(el => el.classList.add("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-2").forEach(el => el.classList.remove("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-3").forEach(el => el.classList.remove("p-vt-controler-active"));
}

function setFontSize2() {
    document.querySelectorAll(".p-novel-body-in").forEach(el => el.style.fontSize = "1.5em");
    document.querySelectorAll(".p-vt-controler-2").forEach(el => el.classList.add("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-1").forEach(el => el.classList.remove("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-3").forEach(el => el.classList.remove("p-vt-controler-active"));
}

function setFontSize3() {
    document.querySelectorAll(".p-novel-body-in").forEach(el => el.style.fontSize = "2em");
    document.querySelectorAll(".p-vt-controler-3").forEach(el => el.classList.add("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-1").forEach(el => el.classList.remove("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-2").forEach(el => el.classList.remove("p-vt-controler-active"));
}

function setVertical() {
    document.querySelectorAll(".p-novel-body").forEach(el => {
        el.classList.add("vertical-text");
        el.classList.remove("horizontal-text");
    });
    document.querySelectorAll(".p-vt-controler-v").forEach(el => el.classList.add("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-h").forEach(el => el.classList.remove("p-vt-controler-active"));
}

function setHorizontal() {
    document.querySelectorAll(".p-novel-body").forEach(el => {
        el.classList.remove("vertical-text");
        el.classList.add("horizontal-text");
    });
    document.querySelectorAll(".p-vt-controler-h").forEach(el => el.classList.add("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-v").forEach(el => el.classList.remove("p-vt-controler-active"));
}

function setFontSansSerif() {
    document.querySelectorAll(".p-novel-body").forEach(el => el.style.fontFamily = "sans-serif");
    document.querySelectorAll(".p-vt-controler-fss").forEach(el => el.classList.add("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-fs").forEach(el => el.classList.remove("p-vt-controler-active"));
}

function setFontSerif() {
    document.querySelectorAll(".p-novel-body").forEach(el => el.style.fontFamily = "serif");
    document.querySelectorAll(".p-vt-controler-fs").forEach(el => el.classList.add("p-vt-controler-active"));
    document.querySelectorAll(".p-vt-controler-fss").forEach(el => el.classList.remove("p-vt-controler-active"));
}

// Cookie設定に基づいて初期化
switch (getCookie("novel_font_size")) {
    case "1":
        setFontSize1();
        break;
    case "2":
        setFontSize2();
        break;
    case "3":
        setFontSize3();
        break;
}
switch (getCookie("novel_text_block")) {
    case "v":
        setVertical();
        break;
    case "h":
        setHorizontal();
        break;
}
switch (getCookie("novel_text_font")) {
    case "s":
        setFontSerif();
        break;
    case "ss":
        setFontSansSerif();
        break;
    default:
        document.querySelectorAll(".p-vt-controler-fs").forEach(el => el.classList.remove("p-vt-controler-active"));
        document.querySelectorAll(".p-vt-controler-fss").forEach(el => el.classList.remove("p-vt-controler-active"));
        break;
}
