<?php

namespace pictpostpersonal {

    ini_set('display_errors', 'Off');

    const PPP_PATH = 'core';

    const ENV_PATH = __DIR__ . '/env';
    const TOKEN_PATH =  __DIR__ . '/env/user_token';
    const USER_PATH = __DIR__ . '/env/user_setting.php';
    const SYSTEM_SETTING_PATH =  __DIR__ . '/env/system_setting.php';
    const TAGCLOUD_PATH =  __DIR__ . '/env/tagcloud.php';
    const SYSTEM_LOG =  __DIR__ . '/env/systemlog/log.php';
    const USER_CSS_PATH =  __DIR__ . '/user_resource/user.css';
    const THEMES_PATH =  __DIR__ . '/themes';

    require_once  __DIR__ . '/' . PPP_PATH . '/autoload.php';

    //システム設定ファイルの存在チェック
    if (!file_exists(SYSTEM_SETTING_PATH) && strstr($_SERVER['REQUEST_URI'], 'convert') !== false) {
        //設定ファイルが存在しない場合は初期化処理へ移行
        require('./' . PPP_PATH . '/createTestArea.php');
        exit();
    }

    if (!file_exists(SYSTEM_SETTING_PATH)) {
        //設定ファイルが存在しない場合は初期化処理へ移行
        require('./' . PPP_PATH . '/initialize.php');
        exit();
    }

    if (!file_exists(USER_PATH)) {
        //ユーザーファイルが存在しない場合はID/パスワード再設定処理へ以降
        require('./' . PPP_PATH . '/initialize.php');
        exit();
    }


    require_once(USER_PATH);
    if (isset($sys_username)) {
        //アップデートが必要な状況。メンテナンスページを表示して処理を抜ける。
        header('HTTP/1.1 503 Service Temporarily Unavailable');
        echo '<!DOCTYPE html><html lang="ja"><head><meta charset="UTF-8"></head><body>ただいまメンテナンス中です</body></html>';
        exit();
    }

    //システムDBへ接続開始
    require_once(SYSTEM_SETTING_PATH);
    if (!file_exists($system_db_file)) {
        header('HTTP/1.1 503 Service Temporarily Unavailable');
        echo 'システムファイルに障害が発生しています。初期化してください。(ERR=1)';
        exit;
    }
    if (isset($debug_mode) && $debug_mode) {
        ini_set('display_errors', 'On');
    }
    if (isset($cache_clear_mode) && $cache_clear_mode) {
        array_map('unlink', glob('./env/template_cache/*.cache'));
    }


    try {
        $db = new \PDO("sqlite:$system_db_file");
        $db->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
    } catch (\Exception $ex) {
        header('HTTP/1.1 503 Service Temporarily Unavailable');
        echo 'システムファイルに障害が発生しています。初期化してください。(ERR=2)';
        echo $ex->getMessage();
        exit;
    }

    //メイン処理を開始する
    $app = new main($db);
    $app->run();
}

namespace {
    //汎用関数定義
    function h($value)
    {
        return htmlspecialchars($value ?? '');
    }

    function s($value)
    {
        return strip_tags($value ?? '');
    }
}
