<?php

class AtomEntry
{
    protected $params = array();

    public function all()
    {
        return $this->params;
    }

    public function title($value, $type = 'text')
    {
        $this->params[] = [
            'name' => 'title',
            'value' => $value,
            'attributes' => ['type' => $type],
            'cdata' => true
        ];
    }

    public function link($href, $rel = 'alternate', $type = null, $title = null, $length = null)
    {
        $this->params[] = [
            'name' => 'link',
            'attributes' => [
                'href' => $href,
                'rel' => $rel,
                'type' => $type,
                'title' => $title,
                'length' => $length
            ]
        ];
    }

    public function updated($value)
    {
        $date = new \DateTime($value);
        $this->params[] = [
            'name' => 'updated',
            'value' => $date->format(\DateTime::RFC3339)
        ];
    }

    public function published($value)
    {
        $date = new \DateTime($value);
        $this->params['published'] = [
            'value' => $date->format(\DateTime::RFC3339)
        ];
    }

    public function author($params)
    {
        $values = array();
        foreach ($params as $key => $value) {
            $values[$key] = ['value' => $value];
        }
        $this->params[] = [
            'name' => 'author',
            'values' => $values
        ];
    }

    public function contributor($params)
    {
        $values = array();
        foreach ($params as $key => $value) {
            $values[$key] = ['value' => $value];
        }
        $this->params[] = [
            'name' => 'contributor',
            'values' => $values
        ];
    }

    public function id($value)
    {
        $this->params[] = [
            'name' => 'id',
            'value' => $value
        ];
    }

    public function summary($value, $type = 'text')
    {
        $this->params[] = [
            'name' => 'summary',
            'value' => $value,
            'attributes' => ['type' => $type],
            'cdata' => true
        ];
    }

    public function thumbnail($value, $type = 'text')
    {
        $this->params[] = [
            'name' => 'thumbnail',
            'value' => $value,
            'attributes' => ['type' => $type],
            'cdata' => true
        ];
    }

    public function content($value = null, $type = 'text', $src = null)
    {
        $this->params[] = [
            'name' => 'content',
            'value' => $value,
            'attributes' => ['type' => $type, 'src' => $src],
            'cdata' => true
        ];
    }

    public function category($term, $scheme = null, $label = null)
    {
        $this->params[] = [
            'name' => 'category',
            'attributes' => [
                'term' => $term,
                'scheme' => $scheme,
                'label' => $label
            ]
        ];
    }

    public function addCustomElement($name, $value, $attributes = array(), $cdata = false)
    {
        $this->params[] = [
            'name' => $name,
            'value' => $value,
            'attributes' => $attributes,
            'cdata' => $cdata
        ];
    }
}
