<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>設定画面 - PictPostPersonal 2</title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Noto+Sans+JP:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/vender/fontawesome/css/all.min.css" rel="preload">

    <!-- Dialog CSS -->
    <link href="{PPP:site_url}/system_resource/css/dialog2.css" rel="stylesheet">

    <link href="{PPP:site_url}/system_resource/css/systemheader.css" rel="stylesheet">

    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_setting.css">

    <script>
        const BASE_URL = "{PPP:base_url}";
    </script>
    <script src="{PPP:site_url}/system_resource/script/dialog2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/common2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/admin2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_common.js" defer></script>
</head>

<body>
    <div class="d-flex">
        <!-- サイドバーオーバーレイ（モバイル用） -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- サイドバー -->
        <nav id="sidebar">
            <div class="sidebar-header">
                <span class="sidebar-title">設定メニュー</span>
                <button id="toggleSidebar" title="サイドバー切替">
                    <i class="bi bi-list"></i>
                </button>
            </div>

            <ul class="nav flex-column mt-3">
                <li class="nav-item">
                    <a class="nav-link active menu-link" data-target="basic" href="#">
                        <i class="bi bi-gear-fill"></i>
                        <span class="menu-text">基本設定</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="index" href="#">
                        <i class="bi bi-house-fill"></i>
                        <span class="menu-text">インデックス</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="entry" href="#">
                        <i class="bi bi-door-open-fill"></i>
                        <span class="menu-text">エントリー</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="nsfw" href="#">
                        <i class="bi bi-shield-exclamation"></i>
                        <span class="menu-text">NSFW設定</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="theme" href="#">
                        <i class="bi bi-palette-fill"></i>
                        <span class="menu-text">テーマ</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="usercss" href="#">
                        <i class="bi bi-filetype-css"></i>
                        <span class="menu-text">ユーザーCSS</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="articles" href="#">
                        <i class="bi bi-file-text-fill"></i>
                        <span class="menu-text">記事表示</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="edit" href="#">
                        <i class="bi bi-pencil-square"></i>
                        <span class="menu-text">記事作成</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="custom" href="#">
                        <i class="bi bi-code-square"></i>
                        <span class="menu-text">カスタム</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="portal" href="#">
                        <i class="bi bi-share-fill"></i>
                        <span class="menu-text">ポータル連携</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="guestmode" href="#">
                        <i class="bi bi-people-fill"></i>
                        <span class="menu-text">ゲストモード</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link menu-link" data-target="system" href="#">
                        <i class="bi bi-sliders"></i>
                        <span class="menu-text">システム</span>
                    </a>
                </li>

                <div style="flex: 1;"></div>
                <li class="nav-item" style="border-top: 1px solid var(--border-light); margin-top: auto;">
                    <a class="nav-link" href="{PPP:base_url}/console">
                        <i class="bi bi-house-fill"></i>
                        <span class="menu-text">ダッシュボード</span>
                    </a>
                </li>
                <ul class="nav">
                    <li class="nav-item">
                        <a class="nav-link" href="{PPP:site_url}/" target="_blank">
                            <i class="bi bi-box-arrow-up-right"></i>
                            <span class="menu-text">サイトを表示</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{PPP:base_url}/logout">
                            <i class="bi bi-box-arrow-right"></i>
                            <span class="menu-text">ログアウト</span>
                        </a>
                    </li>
                </ul>


            </ul>
        </nav>

        <!-- メインコンテンツ -->
        <main id="content">
            <!-- ヘッダー -->
            <div class="system_header system_header_light">
                <a id="back_link" href="{PPP:site_url}/" class="header_link_exit">&lt; TOP</a>
                <div class="header_option_link_area">
                    <span id="notification_link"><i id="notification" class="fa-regular fa-bell font-size:1em"></i></span>
                </div>
            </div>
            <form action="./setting" method="post" enctype="multipart/form-data" autocomplete="off">
                <!-- ヘッダー -->
                <div class="content-header">
                    <div class="header-left d-flex align-items-center">
                        <!-- モバイルメニューボタン -->
                        <button type="button" class="mobile-menu-btn" id="mobileMenuBtn" aria-label="メニューを開く">
                            <i class="bi bi-list"></i>
                        </button>
                        <h1 id="page-title">基本設定</h1>
                    </div>
                    <button type="submit" class="btn btn-primary btn-save" id="saveButton">
                        <i class="bi bi-check-lg"></i> 保存
                    </button>
                </div>

                <!-- 基本設定 -->
                <section id="section_basic" class="active">
                    <h2 class="section-title">基本設定</h2>
                    <p class="section-description">サイトの基本情報とSEO設定を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-info-circle"></i> サイト情報</h3>

                        <div class="form-group">
                            <label for="site_title" class="form-label">サイトタイトル</label>
                            <input type="text" class="form-control" id="site_title" name="site_title"
                                value="{PPP SETTING:site_title}" placeholder="サイト名を入力">
                        </div>

                        <div class="form-group">
                            <label for="image_color" class="form-label">サイトイメージカラー</label>
                            <input type="color" class="form-control form-control-color" id="image_color" name="image_color"
                                value="{PPP SETTING:image_color}" title="カラーを選択">
                        </div>

                        <div class="form-group">
                            <label for="favicon_file" class="form-label">Favicon画像</label>
                            <input class="hide" type="hidden" name="use_favicon" value="0">
                            <input class="form-check-input hide" type="checkbox" id="use_favicon"
                                name="use_favicon" value="1" {PPP SETTING C:use_favicon}>

                            {PPP IF:settings['use_favicon']}
                            <a href="{PPP:site_url}/images/{PPP:settings['favicon']}" target="_blank"><span class="file_status" data-target="favicon_file">[指定あり]</span></a>
                            {PPP ELSE}
                            <span class="file_status" data-target="favicon_file">[指定なし]</span>
                            {PPP ENDIF}
                            <button type="button" class="file_button btn btn-primary btn-sm" data-target="favicon_file">参照</button>
                            <button type="button" class="file_clear_button btn btn-sm btn-secondary" data-target="favicon">クリア</button>
                            <input type="file" class="form-control hide" id="favicon_file" name="favicon_file" accept="image/*">
                            <div class="form-text">推奨サイズ: 32x32px または 64x64px（PNG形式）</div>
                        </div>
                    </div>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-person-circle"></i> 作者情報</h3>

                        <div class="form-group">
                            <label for="display_name" class="form-label">サイト作者名</label>
                            <input type="text" class="form-control" id="display_name" name="display_name"
                                value="{PPP SETTING:display_name}" placeholder="作者名を入力">
                        </div>

                        <div class="form-group">
                            <label for="mail_address" class="form-label">メールアドレス</label>
                            <input type="email" class="form-control" id="mail_address" name="mail_address"
                                value="{PPP SETTING:mail_address}" placeholder="example@example.com">
                        </div>

                        <div class="form-group">
                            <label for="icon" class="form-label">ユーザーアイコン</label>
                            <input class="hide" type="hidden" name="use_icon" value="0">
                            <input class="form-check-input hide" type="checkbox" id="use_icon"
                                name="use_icon" value="1" {PPP SETTING C:use_icon}>
                            {PPP IF:settings['use_icon']}
                            <a href="{PPP:site_url}/images/{PPP:settings['icon']}" target="_blank"><span class="file_status" data-target="icon_file">[指定あり]</span></a>
                            {PPP ELSE}
                            <span class="file_status" data-target="icon_file">[指定なし]</span>
                            {PPP ENDIF}
                            <button type="button" class="file_button btn btn-sm btn-primary" data-target="icon_file">参照</button>
                            <button type="button" class="file_clear_button btn btn-sm btn-secondary" data-target="icon">クリア</button>
                            <input type="file" class="form-control hide" id="icon_file" name="icon_file" accept="image/*">
                            <div class="form-text">推奨サイズ: 128x128px以上（正方形）</div>
                        </div>

                        <div class="form-group">
                            <label for="sns_account" class="form-label">SNSリンク</label>
                            <div class="sns-links-container">
                                <?php foreach ($accounts as $i => $account) : ?>
                                    <div class="sns-link-row" data-row-index="%{$i}">
                                        <span class="sns-link-label">URL%{$i+1}</span>
                                        <input type="hidden" name="sns_id[]" value="%{$account['id']}">
                                        <input type="text" class="sns-url-input" placeholder="https://example.com" value="%{$account['url']}" name="sns_url[]">
                                        <div class="sns-icon-selector">
                                            <div class="sns-icon-preview<?php if (!empty($account['icon'])): ?> has-icon<?php endif; ?>" data-preview-for="%{$i}">
                                                <?php if (!empty($account['icon']) && strpos($account['icon'], 'fa-') !== false): ?>
                                                    <i class="%{$account['icon']}"></i>
                                                <?php elseif (!empty($account['icon'])): ?>
                                                    <img src="{PPP:site_url}/images/<?= $account['icon'] ?>" alt="icon">
                                                <?php endif; ?>
                                            </div>
                                            <button type="button" class="sns-icon-select-btn" data-row="%{$i}">
                                                <i class="bi bi-grid-3x3"></i>
                                                <span>アイコン選択</span>
                                            </button>
                                            <input type="hidden" class="sns-icon-value" value="%{$account['icon']}" name="sns_icon[]">
                                            <input type="file" class="sns-icon-file" name="sns_icon_upload[]" accept="image/*" style="display:none;">
                                        </div>
                                    </div>
                                <?php endforeach ?>
                            </div>
                        </div>

                        <!-- アイコン選択ダイアログ -->
                        <div class="icon-dialog-overlay" id="icon_select_dialog">
                            <div class="icon-dialog">
                                <div class="icon-dialog-header">
                                    <h4 class="icon-dialog-title">
                                        <i class="bi bi-palette"></i>
                                        アイコンを選択
                                    </h4>
                                    <button type="button" class="icon-dialog-close" id="icon-dialog-close">
                                        <i class="bi bi-x-lg"></i>
                                    </button>
                                </div>
                                <div class="icon-dialog-body">
                                    <div class="icon-section-label">SNS・ソーシャル</div>
                                    <div class="icon-grid" id="icon-grid-social">
                                        <div class="icon-grid-item" data-icon="fa-brands fa-x-twitter" title="X (Twitter)"><i class="fa-brands fa-x-twitter"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-twitter" title="Twitter"><i class="fa-brands fa-twitter"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-square-x-twitter" title="X Square"><i class="fa-brands fa-square-x-twitter"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-mastodon" title="Mastodon"><i class="fa-brands fa-mastodon"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-bluesky" title="Bluesky"><i class="fa-brands fa-bluesky"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-facebook" title="Facebook"><i class="fa-brands fa-facebook"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-instagram" title="Instagram"><i class="fa-brands fa-instagram"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-threads" title="Threads"><i class="fa-brands fa-threads"></i></div>
                                    </div>

                                    <div class="icon-section-label">クリエイティブ</div>
                                    <div class="icon-grid" id="icon-grid-creative">
                                        <div class="icon-grid-item" data-icon="fa-brands fa-pixiv" title="pixiv"><i class="fa-brands fa-pixiv"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-deviantart" title="DeviantArt"><i class="fa-brands fa-deviantart"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-artstation" title="ArtStation"><i class="fa-brands fa-artstation"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-behance" title="Behance"><i class="fa-brands fa-behance"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-dribbble" title="Dribbble"><i class="fa-brands fa-dribbble"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-flickr" title="Flickr"><i class="fa-brands fa-flickr"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-500px" title="500px"><i class="fa-brands fa-500px"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-unsplash" title="Unsplash"><i class="fa-brands fa-unsplash"></i></div>
                                    </div>

                                    <div class="icon-section-label">動画・配信</div>
                                    <div class="icon-grid" id="icon-grid-video">
                                        <div class="icon-grid-item" data-icon="fa-brands fa-youtube" title="YouTube"><i class="fa-brands fa-youtube"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-twitch" title="Twitch"><i class="fa-brands fa-twitch"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-tiktok" title="TikTok"><i class="fa-brands fa-tiktok"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-vimeo" title="Vimeo"><i class="fa-brands fa-vimeo"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-bilibili" title="bilibili"><i class="fa-brands fa-bilibili"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-solid fa-podcast" title="Podcast"><i class="fa-solid fa-podcast"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-spotify" title="Spotify"><i class="fa-brands fa-spotify"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-soundcloud" title="SoundCloud"><i class="fa-brands fa-soundcloud"></i></div>
                                    </div>

                                    <div class="icon-section-label">その他</div>
                                    <div class="icon-grid" id="icon-grid-other">
                                        <div class="icon-grid-item" data-icon="fa-solid fa-globe" title="ウェブサイト"><i class="fa-solid fa-globe"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-solid fa-envelope" title="メール"><i class="fa-solid fa-envelope"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-github" title="GitHub"><i class="fa-brands fa-github"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-discord" title="Discord"><i class="fa-brands fa-discord"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-brands fa-patreon" title="Patreon"><i class="fa-brands fa-patreon"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-solid fa-store" title="ショップ"><i class="fa-solid fa-store"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-solid fa-link" title="リンク"><i class="fa-solid fa-link"></i></div>
                                        <div class="icon-grid-item" data-icon="fa-solid fa-rss" title="RSS"><i class="fa-solid fa-rss"></i></div>
                                    </div>

                                    <div class="icon-section-label">カスタム画像をアップロード</div>
                                    <div class="icon-upload-zone" id="icon-upload-zone">
                                        <div class="icon-upload-icon"><i class="bi bi-cloud-arrow-up"></i></div>
                                        <div class="icon-upload-text">クリックまたはドラッグ&amp;ドロップ</div>
                                        <div class="icon-upload-hint">PNG, JPG, SVG / 最大 2MB</div>
                                        <input type="file" id="icon-upload-input" accept="image/*" style="display:none;">
                                    </div>
                                </div>
                                <div class="icon-dialog-footer">
                                    <div class="icon-preview-selected">
                                        <div class="icon-preview-box" id="icon-preview-box">
                                            <i class="bi bi-question-lg" style="color:var(--text-light);"></i>
                                        </div>
                                        <span class="icon-preview-label" id="icon-preview-label">未選択</span>
                                    </div>
                                    <div class="icon-dialog-actions">
                                        <button type="button" class="icon-btn-clear" id="icon-btn-clear">クリア</button>
                                        <button type="button" class="icon-btn-confirm" id="icon-btn-confirm">選択を確定</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-search"></i> SEO設定</h3>

                        <div class="form-group">
                            <label for="keywords" class="form-label">キーワード</label>
                            <input type="text" class="form-control" id="keywords" name="keywords"
                                value="{PPP SETTING:keywords}" placeholder="カンマ区切りで入力">
                            <div class="form-text">例: イラスト, 漫画, アート</div>
                        </div>

                        <div class="form-group">
                            <label for="og_text" class="form-label">短いサイト説明文</label>
                            <input type="text" class="form-control" id="og_text" name="og_text"
                                value="{PPP SETTING:og_text}" placeholder="サイトの簡単な説明">
                            <div class="form-text">SNSでシェアされた際などに表示される説明文（100文字以内推奨）</div>
                        </div>


                        <div class="form-group">
                            <input class="hide" type="hidden" name="use_ogimage" value="0">
                            <input class="form-check-input hide" type="checkbox" id="use_ogimage"
                                name="use_ogimage" value="1" {PPP SETTING C:use_ogimage}>

                            <label for="ogimage" class="form-label">サイトイメージ画像</label>
                            {PPP IF:settings['use_ogimage']}
                            <a href="{PPP:site_url}/images/{PPP:settings['ogimage']}" target="_blank"><span class="file_status" data-target="ogimage_file">[指定あり]</span></a>
                            {PPP ELSE}
                            <span class="file_status" data-target="ogimage_file">[指定なし]</span>
                            {PPP ENDIF}
                            <button type="button" class="file_button btn btn-sm btn-primary" data-target="ogimage_file">参照</button>
                            <button type="button" class="file_clear_button btn btn-sm btn-secondary" data-target="ogimage">クリア</button>
                            <input type="file" class="form-control hide" id="ogimage_file" name="ogimage_file" accept="image/*">
                            <div class="form-text">推奨サイズ: 1200x630px（PNG、JPG形式）</div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">検索除外設定</label>
                            <div class="form-check">
                                <input class="hide" type="hidden" name="no_robots" value="0">
                                <input class="form-check-input" type="checkbox" id="no_robots"
                                    name="no_robots" value="1" {PPP SETTING C:no_robots}>
                                <label class="form-check-label" for="no_robots">
                                    ロボット検索除外設定を行う（noindex, nofollow）
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-chat-dots"></i> フィードバック</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input class="hide" type="hidden" name="use_feedback" value="0">
                                <input class="form-check-input" type="checkbox" id="use_feedback"
                                    name="use_feedback" value="1" {PPP SETTING C:use_feedback}>
                                <label class="form-check-label" for="use_feedback">
                                    フィードバック機能を利用する
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link" style="visibility: hidden;"></button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="index">
                            インデックスページ設定 <i class="bi bi-arrow-right-short"></i>
                        </button>
                    </div>
                </section>

                <!-- インデックスページ設定 -->
                <section id="section_index">
                    <h2 class="section-title">インデックスページ設定</h2>
                    <p class="section-description">トップページの表示設定を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-image"></i> ビジュアル要素</h3>
                        <p class="section-description">※テーマによっては使用されないことがあります</p>
                        <div class="form-group">
                            <label class="form-label">トップバナー画像</label>
                            <input class="hide" type="hidden" name="use_banner" value="0">
                            <input class="form-check-input hide" type="checkbox" id="use_banner"
                                name="use_banner" value="1" {PPP SETTING C:use_banner}>
                            {PPP IF:settings['use_banner']}
                            <a href="{PPP:site_url}/images/{PPP:settings['banner']}" target="_blank"><span class="file_status" data-target="banner_file">[指定あり]</span></a>
                            {PPP ELSE}
                            <span class="file_status" data-target="banner_file">[指定なし]</span>
                            {PPP ENDIF}
                            <button type="button" class="file_button btn btn-sm btn-primary" data-target="banner_file">参照</button>
                            <button type="button" class="file_clear_button btn btn-sm btn-secondary" data-target="banner">クリア</button>
                            <input type="file" class="form-control hide" id="banner_file" name="banner_file" accept="image/*">
                            <div class="form-text">トップページ先頭に表示されるイメージ画像です。推奨サイズ: 横幅1200px以上</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">サイト名の表示</label>
                            <div class="form-check">
                                <input type="hidden" name="show_title" value="0">
                                <input class="form-check-input" type="checkbox" id="show_title"
                                    name="show_title" value="1" {PPP SETTING C:show_title}>
                                <label class="form-check-label" for="show_title">
                                    タイトルを文字で表示する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">ミニバナー画像</label>
                            <input class="hide" type="hidden" name="use_mini_banner" value="0">
                            <input class="form-check-input hide" type="checkbox" id="use_mini_banner"
                                name="use_mini_banner" value="1" {PPP SETTING C:use_mini_banner}>


                            {PPP IF:settings['use_mini_banner']}
                            <a href="{PPP:site_url}/images/{PPP:settings['mini_banner']}" target="_blank"><span class="file_status" data-target="mini_banner_file">[指定あり]</span></a>
                            {PPP ELSE}
                            <span class="file_status" data-target="mini_banner_file">[指定なし]</span>
                            {PPP ENDIF}
                            <button type="button" class="file_button btn btn-sm btn-primary" data-target="mini_banner_file">参照</button>
                            <button type="button" class="file_clear_button btn btn-sm btn-secondary" data-target="mini_banner">クリア</button>
                            <input type="file" class="form-control hide" id="mini_banner_file" name="mini_banner_file" accept="image/*">
                            <div class="form-text">推奨サイズ: 200x40px</div>
                        </div>


                    </div>
                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-file-text"></i> 案内文</h3>
                        <div class="form-group">
                            <label for="index_text" class="form-label">インデックスページ案内文</label>
                            <textarea class="form-control" id="index_text" name="index_text" data-syntax-editor
                                rows="25">{PPP SETTING:index_text}</textarea>
                        </div>
                    </div>
                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-list-ul"></i> 表示設定</h3>
                        <label class="form-label">サイト名の表示</label>
                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_tag_cloud" value="0">
                                <input class="form-check-input" type="checkbox" id="use_tag_cloud"
                                    name="use_tag_cloud" value="1" {PPP SETTING C:use_tag_cloud}>
                                <label class="form-check-label" for="use_tag_cloud">
                                    タグクラウドを表示する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exclude_index_list_tag" class="form-label">一覧表示除外タグ</label>
                            <input type="text" class="form-control" id="exclude_index_list_tag"
                                name="exclude_index_list_tag" value="{PPP SETTING:exclude_index_list_tag}"
                                placeholder="スペース区切りで入力">
                            <div class="form-text">指定したタグが付いた記事は一覧に表示されません</div>
                        </div>

                        <div class="form-group">
                            <label for="index_articles" class="form-label">一覧表示件数</label>
                            <input type="number" class="form-control" id="index_articles"
                                name="index_articles" value="{PPP SETTING:index_articles}" min="1" max="100">
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="basic">
                            <i class="bi bi-arrow-left"></i> 基本設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="entry">
                            エントリーページ設定 <i class="bi bi-arrow-right-short"></i>
                        </button>
                    </div>
                </section>

                <!-- エントリーページ設定 -->
                <section id="section_entry">
                    <h2 class="section-title">エントリーページ設定</h2>
                    <p class="section-description">サイト訪問時の入場ページ設定を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-door-open-fill"></i> 入場設定</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_entry" value="0">
                                <input class="form-check-input" type="checkbox" id="use_entry"
                                    name="use_entry" value="1" {PPP SETTING C:use_entry}>
                                <label class="form-check-label" for="use_entry">
                                    エントリーページを使用する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="entry_text" class="form-label">入場ページ案内文</label>
                            <textarea class="form-control" id="entry_text" name="entry_text" data-syntax-editor
                                rows="15">{PPP SETTING:entry_text}</textarea>
                        </div>

                        <div class="form-group">
                            <label for="entry_password" class="form-label">入場用あいことば</label>
                            <input type="text" class="form-control" id="entry_password"
                                name="entry_password" value="{PPP SETTING:entry_password}">
                            <p class="form-text">入場時に必要な「あいことば」を設定します。空の場合は合言葉不要となります。</p>
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="index">
                            <i class="bi bi-arrow-left"></i> インデックスページ設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="nsfw">
                            NSFW設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- NSFW設定 -->
                <section id="section_nsfw">
                    <h2 class="section-title">NSFW設定</h2>
                    <p class="section-description">年齢制限コンテンツの設定を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-shield-exclamation"></i> NSFW動作</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_nsfw" value="0">
                                <input class="form-check-input" type="checkbox" id="use_nsfw"
                                    name="use_nsfw" value="1" {PPP SETTING C:use_nsfw}>
                                <label class="form-check-label" for="use_nsfw">
                                    サイト全体をNSFW指定する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_aloways_nsfw" value="0">
                                <input class="form-check-input" type="checkbox" id="use_aloways_nsfw"
                                    name="use_aloways_nsfw" value="1" {PPP SETTING C:use_aloways_nsfw}>
                                <label class="form-check-label" for="use_aloways_nsfw">
                                    2回目以降の訪問時もNSFW確認する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="nsfw_text" class="form-label">NSFW確認ページ案内文</label>
                            <textarea class="form-control" id="nsfw_text" name="nsfw_text" data-syntax-editor
                                rows="5">{PPP SETTING:nsfw_text}</textarea>
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="entry">
                            <i class="bi bi-arrow-left"></i> エントリーページ設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="theme">
                            テーマ設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- テーマ設定 -->
                <section id="section_theme">
                    <h2 class="section-title">テーマ設定</h2>
                    <p class="section-description">サイトのデザインテーマを管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-palette"></i> テーマ選択</h3>

                        <div class="form-group">
                            <label for="theme" class="form-label">テーマ名</label>
                            <select class="form-select" id="theme" name="theme">
                                <option value="" {PPP SETTING S:theme, '' }>デフォルトテーマ</option>
                                {PPP LOOP:themes}
                                <option value="{PPP:themes.theme}" {PPP SETTING S:theme,themes.theme}>{PPP:themes.title}</option>
                                {/PPP LOOP}
                            </select>
                        </div>
                        {PPP:themes_setting_html}
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="nsfw">
                            <i class="bi bi-arrow-left"></i> NSFW設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="usercss">
                            ユーザーCSS <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- ユーザーCSS -->
                <section id="section_usercss">
                    <h2 class="section-title">ユーザーCSS</h2>
                    <p class="section-description">カスタムCSSを記述してサイトのデザインをカスタマイズできます</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-code-slash"></i> カスタムCSS</h3>

                        <div class="form-group">
                            <label for="user_css" class="form-label">CSS</label>
                            <textarea class="form-control" id="user_css" name="user_css" rows="20" data-syntax-editor data-syntax-type="css">{PPP SETTING:user_css}</textarea>
                            <small class="form-text text-muted">
                                ここに記述したCSSは /user_resource/user.css に保存され、サイト全体に適用されます。
                            </small>
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="theme">
                            <i class="bi bi-arrow-left"></i> テーマ設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="articles">
                            記事ページ動作設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- 記事ページ動作設定 -->
                <section id="section_articles">
                    <h2 class="section-title">記事ページ動作設定</h2>
                    <p class="section-description">記事の表示と動作に関する設定を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-arrow-left-right"></i> ナビゲーション</h3>

                        <div class="form-group">
                            <label for="move_link_type" class="form-label">前後移動条件</label>
                            <select class="form-select" id="move_link_type" name="move_link_type">
                                <option value="0" {PPP SETTING S:move_link_type,0}>表示しない</option>
                                <option value="1" {PPP SETTING S:move_link_type,1}>すべての記事の中で移動</option>
                                <option value="2" {PPP SETTING S:move_link_type,2}>タグが一致する記事の中で移動</option>
                                <option value="3" {PPP SETTING S:move_link_type,3}>プライマリタグが一致する記事の中で移動</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="move_link_title" class="form-label">記事移動ラベル</label>
                            <select class="form-select" id="move_link_title" name="move_link_title">
                                <option value="1" {PPP SETTING S:move_link_title,0}>「前へ/次へ」表示</option>
                                <option value="2" {PPP SETTING S:move_link_title,1}>タイトルを表示</option>
                            </select>
                        </div>

                    </div>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-eye"></i> 表示機能</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_lightbox" value="0">
                                <input class="form-check-input" type="checkbox" id="use_lightbox"
                                    name="use_lightbox" value="1" {PPP SETTING C:use_lightbox}>
                                <label class="form-check-label" for="use_lightbox">
                                    Lightboxを使用する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="show_likes" value="0">
                                <input class="form-check-input" type="checkbox" id="show_likes"
                                    name="show_likes" value="1" {PPP SETTING C:show_likes}>
                                <label class="form-check-label" for="show_likes">
                                    いいね数を記事に表示する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="show_views" value="0">
                                <input class="form-check-input" type="checkbox" id="show_views"
                                    name="show_views" value="1" {PPP SETTING C:show_views}>
                                <label class="form-check-label" for="show_views">
                                    表示数を記事に表示する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="show_share_button" value="0">
                                <input class="form-check-input" type="checkbox" id="show_share_button"
                                    name="show_share_button" value="1" {PPP SETTING C:show_share_button}>
                                <label class="form-check-label" for="show_share_button">
                                    シェアボタンを記事に表示する
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="usercss">
                            <i class="bi bi-arrow-left"></i> ユーザーCSS
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="edit">
                            編集画面設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- 記事作成設定 -->
                <section id="section_edit">
                    <h2 class="section-title">記事作成設定</h2>
                    <p class="section-description">記事作成時のデフォルト設定と画像処理を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-file-earmark-text"></i> デフォルト設定</h3>

                        <div class="form-group">
                            <label for="default_style" class="form-label">デフォルト記事スタイル</label>
                            <select class="form-select" id="default_style" name="default_style">
                                <option value="0" {PPP SETTING S:default_style,0}>通常</option>
                                <option value="1" {PPP SETTING S:default_style,1}>詳細</option>
                                <option value="4" {PPP SETTING S:default_style,4}>漫画[左]</option>
                                <option value="5" {PPP SETTING S:default_style,5}>漫画[右]</option>
                                <option value="6" {PPP SETTING S:default_style,6}>漫画[左・見開き]</option>
                                <option value="7" {PPP SETTING S:default_style,7}>漫画[右・見開き]</option>
                                <option value="2" {PPP SETTING S:default_style,2}>小説[横]</option>
                                <option value="3" {PPP SETTING S:default_style,3}>小説[縦]</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="title_template" class="form-label">デフォルトタイトル</label>
                            <input type="text" class="form-control" id="title_template"
                                name="title_template" value="{PPP SETTING:title_template}">
                        </div>

                        <div class="form-group">
                            <label for="contents_template" class="form-label">デフォルト記事内容</label>
                            <textarea class="form-control" id="contents_template"
                                name="contents_template" rows="5">{PPP SETTING:contents_template}</textarea>
                        </div>
                    </div>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-images"></i> 画像処理</h3>

                        <div class="form-group">
                            <label for="resize_border" class="form-label">画像リサイズ閾値（px）</label>
                            <input type="number" class="form-control" id="resize_border"
                                name="resize_border" value="{PPP SETTING:resize_border}">
                            <div class="form-text">長辺がこの値を超える画像は自動的にリサイズされます。<br>0を指定するとリサイズされなくなります。</div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="thumb_width" class="form-label">サムネイル幅（px）</label>
                                    <input type="number" class="form-control" id="thumb_width"
                                        name="thumb_width" value="{PPP SETTING:thumb_width}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="thumb_height" class="form-label">サムネイル高さ（px）</label>
                                    <input type="number" class="form-control" id="thumb_height"
                                        name="thumb_height" value="{PPP SETTING:thumb_height}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="thumb_l_width" class="form-label">大サムネイル幅（px）</label>
                                    <input type="number" class="form-control" id="thumb_l_width"
                                        name="thumb_l_width" value="{PPP SETTING:thumb_l_width}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="thumb_l_height" class="form-label">大サムネイル高さ（px）</label>
                                    <input type="number" class="form-control" id="thumb_l_height"
                                        name="thumb_l_height" value="{PPP SETTING:thumb_l_height}">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="write_exif" value="0">
                                <input class="form-check-input" type="checkbox" id="write_exif"
                                    name="write_exif" value="1" {PPP SETTING C:write_exif}>
                                <label class="form-check-label" for="write_exif">
                                    画像コメント欄にEXIF情報を取り込む
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_rnd_filename" value="0">
                                <input class="form-check-input" type="checkbox" id="use_rnd_filename"
                                    name="use_rnd_filename" value="1" {PPP SETTING C:use_rnd_filename}>
                                <label class="form-check-label" for="use_rnd_filename">
                                    画像ファイル名をランダムにする
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-markdown"></i> 入力書式</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_markdown" value="0">
                                <input class="form-check-input" type="checkbox" id="use_markdown"
                                    name="use_markdown" value="1" {PPP SETTING C:use_markdown}>
                                <label class="form-check-label" for="use_markdown">
                                    Markdownを使用する
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_mini_markdown" value="0">
                                <input class="form-check-input" type="checkbox" id="use_mini_markdown"
                                    name="use_mini_markdown" value="1" {PPP SETTING C:use_mini_markdown}>
                                <label class="form-check-label" for="use_mini_markdown">
                                    簡易Markdownを使用する
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-share"></i> SNSシェア設定</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="sns_share_use_clipboard" value="0">
                                <input class="form-check-input" type="checkbox" id="sns_share_use_clipboard"
                                    name="sns_share_use_clipboard" value="1" {PPP SETTING C:sns_share_use_clipboard}>
                                <label class="form-check-label" for="sns_share_use_clipboard">
                                    シェア動作時にクリップボードに画像をコピーする
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="tweet_service" class="form-label">X連携用サービスURL</label>
                            <input type="url" class="form-control" id="tweet_service"
                                name="tweet_service" value="{PPP SETTING:tweet_service}">
                        </div>

                        <div class="form-group">
                            <label for="tweet_service_key" class="form-label">X連携用API Key</label>
                            <input type="text" class="form-control" id="tweet_service_key"
                                name="tweet_service_key" value="{PPP SETTING:tweet_service_key}">
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="articles">
                            <i class="bi bi-arrow-left"></i> 記事ページ動作設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="custom">
                            カスタムコード設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- カスタム動作設定 -->
                <section id="section_custom">
                    <h2 class="section-title">カスタム動作設定</h2>
                    <p class="section-description">HTMLコードの挿入位置を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-code-slash"></i> HTMLコード挿入</h3>
                        <p class="section-description">各記事ページの先頭・末尾に挿入するHTMLを指定します</p>
                        <div class="form-group">
                            <label for="contents_header" class="form-label">記事先頭に挿入するHTML</label>
                            <textarea class="form-control" id="contents_header"
                                name="contents_header" rows="4">{PPP SETTING:contents_header}</textarea>
                        </div>

                        <div class="form-group">
                            <label for="contents_footer" class="form-label">記事末尾に挿入するHTML</label>
                            <textarea class="form-control" id="contents_footer"
                                name="contents_footer" rows="4">{PPP SETTING:contents_footer}</textarea>
                        </div>

                        <p class="section-description">全ページの先頭・末尾に挿入するHTMLを指定します</p>

                        <div class="form-group">
                            <label for="insert_header" class="form-label">&lt;/head&gt;直前に挿入するHTML</label>
                            <textarea class="form-control" id="insert_header"
                                name="insert_header" rows="4">{PPP SETTING:insert_header}</textarea>
                            <div class="form-text">Google Analyticsなどのトラッキングコードをここに記述</div>
                        </div>

                        <div class="form-group">
                            <label for="insert_body_header" class="form-label">&lt;body&gt;直後に挿入するHTML</label>
                            <textarea class="form-control" id="insert_body_header"
                                name="insert_body_header" rows="4">{PPP SETTING:insert_body_header}</textarea>
                        </div>

                        <div class="form-group">
                            <label for="insert_body_footer" class="form-label">&lt;/body&gt;直前に挿入するHTML</label>
                            <textarea class="form-control" id="insert_body_footer"
                                name="insert_body_footer" rows="4">{PPP SETTING:insert_body_footer}</textarea>
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="edit">
                            <i class="bi bi-arrow-left"></i> 編集画面設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="portal">
                            ポータルサイト設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- ポータル連携設定 -->
                <section id="section_portal">
                    <h2 class="section-title">ポータル連携設定</h2>
                    <p class="section-description">外部ポータルサイトとの連携を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-globe"></i> ポータル連動</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_portal_feed" value="0">
                                <input class="form-check-input" type="checkbox" id="use_portal_feed"
                                    name="use_portal_feed" value="1" {PPP SETTING C:use_portal_feed}>
                                <label class="form-check-label" for="use_portal_feed">
                                    ポータル連携を有効にする
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="portal_feed_urls" class="form-label">ポータル連動URL</label>
                            <input type="url" class="form-control" id="portal_feed_urls"
                                name="portal_feed_urls" value="{PPP SETTING:portal_feed_urls}">
                            <div class="form-text">複数のURLはカンマ区切りで入力</div>
                        </div>

                        <div class="form-group">
                            <label for="portal_post_tags" class="form-label">ポータル連動タグ</label>
                            <input type="text" class="form-control" id="portal_post_tags"
                                name="portal_post_tags" value="{PPP SETTING:portal_post_tags}"
                                placeholder="スペース区切りで入力">
                            <div class="form-text">指定したタグが付いた記事のみポータルに送信されます</div>
                        </div>

                        <div class="form-group">
                            <label for="exclude_portal_post_tags" class="form-label">ポータル連動対象外タグ</label>
                            <input type="text" class="form-control" id="exclude_portal_post_tags"
                                name="exclude_portal_post_tags" value="{PPP SETTING:exclude_portal_post_tags}"
                                placeholder="スペース区切りで入力">
                            <div class="form-text">指定したタグが付いた記事はポータルに送信されません</div>
                        </div>

                        <div class="form-group">
                            <label for="portal_tags" class="form-label">サイト登録タグ</label>
                            <input type="text" class="form-control" id="portal_tags"
                                name="portal_tags" value="{PPP SETTING:portal_tags}"
                                placeholder="スペース区切りで入力">
                            <div class="form-text">ポータルサイトに登録するサイト全体のタグ</div>
                        </div>
                    </div>

                    <!-- セクションナビゲータ -->
                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="custom">
                            <i class="bi bi-arrow-left"></i> カスタムコード設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link next nav-section-link" data-target="guestmode">
                            ゲストモード設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- ゲストモード設定 -->
                <section id="section_guestmode">
                    <h2 class="section-title">ゲストモード設定</h2>
                    <p class="section-description">ゲストユーザーによる記事投稿機能を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-person-plus"></i> ゲスト投稿</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_guestwrite" value="0">
                                <input class="form-check-input" type="checkbox" id="use_guestwrite"
                                    name="use_guestwrite" value="1" {PPP SETTING C:use_guestwrite}>
                                <label class="form-check-label" for="use_guestwrite">
                                    ゲストモードを有効にする
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="guest_attention" class="form-label">ゲスト記事投稿画面 案内文</label>
                            <textarea class="form-control" id="guest_attention"
                                name="guest_attention" rows="5">{PPP SETTING:guest_attention}</textarea>
                            <div class="form-text">ゲストユーザーに表示される注意事項や利用規約を記述</div>
                        </div>
                    </div>

                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="portal">
                            <i class="bi bi-arrow-left"></i> ポータルサイト設定
                        </button>
                        <div class="nav-spacer"></div>
                        <button class="nav-link prev nav-section-link" data-target="system">
                            システム設定 <i class="bi bi-arrow-right"></i>
                        </button>
                    </div>
                </section>

                <!-- システム設定 -->
                <section id="section_system">
                    <h2 class="section-title">システム詳細設定</h2>
                    <p class="section-description">システムの動作環境とパフォーマンス設定を管理します</p>

                    <div class="settings-card">
                        <h3 class="card-title"><i class="bi bi-server"></i> サーバー設定</h3>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="use_rewrite" value="0">
                                <input class="form-check-input" type="checkbox" id="use_rewrite"
                                    name="use_rewrite" value="1" {PPP SETTING C:use_rewrite}>
                                <label class="form-check-label" for="use_rewrite">
                                    mod_rewriteを使用する
                                </label>
                            </div>
                            <div class="form-text">有効にすると綺麗なURLが使用できます（.htaccessが必要）</div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="hidden" name="always_on_ssl" value="0">
                                <input class="form-check-input" type="checkbox" id="always_on_ssl"
                                    name="always_on_ssl" value="1" {PPP SETTING C:always_on_ssl}>
                                <label class="form-check-label" for="always_on_ssl">
                                    常時HTTPSを使用する
                                </label>
                            </div>
                            <div class="form-text">HTTPアクセスを自動的にHTTPSにリダイレクトします</div>
                        </div>

                        <div class="form-group">
                            <label for="log_level" class="form-label">ログレベル</label>
                            <select class="form-select" id="log_level" name="log_level">
                                <option value="0" {PPP SETTING S:log_level,0}>エラーのみ</option>
                                <option value="1" {PPP SETTING S:log_level,1}>警告以上</option>
                                <option value="2" {PPP SETTING S:log_level,2}>情報以上</option>
                                <option value="3" {PPP SETTING S:log_level,3}>デバッグ（全て）</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="timezone" class="form-label">タイムゾーン</label>
                            <select class="form-select" id="timezone" name="timezone">
                                <option value="Asia/Tokyo" {PPP SETTING S:timezone,"Asia/Tokyo"}>Asia/Tokyo (日本標準時)</option>
                                <option value="Asia/Shanghai" {PPP SETTING S:timezone,"Asia/Shanghai"}>Asia/Shanghai (中国標準時)</option>
                                <option value="Europe/London" {PPP SETTING S:timezone,"Europe/London"}>Europe/London (グリニッジ標準時)</option>
                                <option value="America/New_York" {PPP SETTING S:timezone,"America/New_York"}>America/New_York (東部標準時)</option>
                                <option value="America/Los_Angeles" {PPP SETTING S:timezone,"America/Los_Angeles"}>America/Los_Angeles (太平洋標準時)</option>
                                <option value="UTC" {PPP SETTING S:timezone,"UTC"}>UTC (協定世界時)</option>
                            </select>
                        </div>
                    </div>

                    <div class="section-navigator">
                        <button class="nav-link prev nav-section-link" data-target="guestmode">
                            <i class="bi bi-arrow-left"></i> ゲストモード設定
                        </button>
                    </div>
                </section>
                {PPP:csrf}
            </form>
        </main>
    </div>



    <script>
        // 要素の取得
        var pageTitle = document.getElementById("page-title");

        var titleMap = {
            'basic': '基本設定',
            'index': 'インデックスページ設定',
            'entry': 'エントリーページ設定',
            'nsfw': 'NSFW設定',
            'theme': 'テーマ設定',
            'usercss': 'ユーザーCSS',
            'articles': '記事ページ動作設定',
            'edit': '記事作成設定',
            'custom': 'カスタム動作設定',
            'portal': 'ポータル連携設定',
            'guestmode': 'ゲストモード設定',
            'system': 'システム詳細設定'
        };

        // セクション切り替え関数
        function switchSection(targetKey, clickedLink) {
            var links = document.querySelectorAll(".menu-link");
            var sections = document.querySelectorAll("section");
            var targetId = "section_" + targetKey;

            // メニューのアクティブ状態を更新
            for (var i = 0; i < links.length; i++) {
                links[i].classList.remove("active");
            }
            if (clickedLink) {
                clickedLink.classList.add("active");
            }

            // 全セクション非表示
            for (var j = 0; j < sections.length; j++) {

                sections[j].classList.remove("active");
            }

            // ターゲットを表示
            var targetSection = document.getElementById(targetId);
            if (targetSection) {
                targetSection.classList.add("active");
                if (pageTitle) {
                    pageTitle.textContent = titleMap[targetKey] || '設定';
                }
                window.scrollTo(0, 0);
            }

            // モバイルの場合はメニューを閉じる
            if (window.innerWidth <= 768) {
                ConsoleCommon.closeMobileMenu();
            }
        }

        // 左側メニューの動作設定
        var menuLinks = document.querySelectorAll(".menu-link");
        for (var k = 0; k < menuLinks.length; k++) {

            (function(link) {

                link.addEventListener("click", function(e) {
                    e.preventDefault();
                    var targetKey = link.getAttribute("data-target");
                    if (targetKey) {
                        switchSection(targetKey, link);
                    }
                });
            })(menuLinks[k]);
        }

        // セクションナビゲーターボタンの動作設定
        var navSectionLinks = document.querySelectorAll(".nav-section-link");
        for (var n = 0; n < navSectionLinks.length; n++) {
            (function(button) {
                button.addEventListener("click", function(e) {
                    e.preventDefault();
                    var targetKey = button.getAttribute("data-target");
                    if (targetKey) {
                        // 対応するメニューリンクを取得
                        var menuLink = document.querySelector(".menu-link[data-target='" + targetKey + "']");
                        switchSection(targetKey, menuLink);
                    }
                });
            })(navSectionLinks[n]);
        }

        // テーマメニューの動作設定
        var themeSelecter = document.getElementById("theme");
        if (themeSelecter) {
            themeSelecter.addEventListener("change", function(e) {
                var themeSections = document.querySelectorAll(".theme_section");
                var targetId = "theme_setting_" + e.target.value;

                for (var i = 0; i < themeSections.length; i++) {
                    themeSections[i].classList.remove("active");
                }

                var targetSection = document.getElementById(targetId);
                if (targetSection) {
                    targetSection.classList.add("active");
                }
            });
        }

        // ファイルボタン動作設定
        var fileButtons = document.querySelectorAll('.file_button');
        for (var m = 0; m < fileButtons.length; m++) {
            (function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    var targetId = button.getAttribute("data-target");
                    var fileInput = document.getElementById(targetId);
                    if (fileInput) {
                        fileInput.click();
                    }
                });
            })(fileButtons[m]);
        }

        // ファイル入力のchangeイベント設定
        var fileInputs = document.querySelectorAll('input[type="file"]');
        for (var o = 0; o < fileInputs.length; o++) {
            (function(fileInput) {
                fileInput.addEventListener('change', function(e) {
                    if (fileInput.files.length > 0) {
                        var targetId = fileInput.id;
                        var fileStatus = document.querySelector('.file_status[data-target="' + targetId + '"]');
                        if (fileStatus) {
                            fileStatus.textContent = "[指定あり]";
                            // 親要素がアンカータグの場合、span要素だけにする
                            if (fileStatus.parentElement && fileStatus.parentElement.tagName.toLowerCase() === 'a') {
                                var parentAnchor = fileStatus.parentElement;
                                parentAnchor.parentNode.replaceChild(fileStatus, parentAnchor);
                            }
                        }
                        // 対応するチェックボックスをチェック
                        var useCheckbox = document.getElementById("use_" + targetId.replace('_file', ''));
                        if (useCheckbox) {
                            useCheckbox.checked = true;
                        }
                    }
                });
            })(fileInputs[o]);
        }

        var fileClearButtons = document.querySelectorAll('.file_clear_button');
        for (var n = 0; n < fileClearButtons.length; n++) {
            (function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    var targetId = button.getAttribute("data-target");
                    var fileInput = document.getElementById(targetId + "_file");
                    if (fileInput) {
                        fileInput.value = "";
                    }
                    var fileCheck = document.getElementById("use_" + targetId);
                    if (fileCheck) {
                        fileCheck.checked = false;
                    }
                    var fileStatus = document.querySelector('.file_status[data-target="' + targetId + '_file"]');
                    if (fileStatus) {
                        fileStatus.textContent = "[指定なし]";
                        if (fileStatus.parentElement && fileStatus.parentElement.tagName.toLowerCase() === 'a') {
                            var parentAnchor = fileStatus.parentElement;
                            var fragment = document.createDocumentFragment();
                            while (parentAnchor.firstChild) {
                                fragment.appendChild(parentAnchor.firstChild);
                            }
                            parentAnchor.parentNode.replaceChild(fragment, parentAnchor);
                        }
                    }
                });
            })(fileClearButtons[n]);
        }

        // ウィンドウリサイズ時の処理
        window.addEventListener("resize", function() {
            if (window.innerWidth > 768) {
                closeMobileMenu();
            }
        });
    </script>

    <!-- 非同期保存処理 -->
    <script>
        (function() {
            var settingsForm = document.querySelector('form[action="./setting"]');
            var saveButton = document.getElementById('saveButton');

            if (!settingsForm || !saveButton) return;

            // フォーム送信をインターセプト
            settingsForm.addEventListener('submit', function(e) {
                e.preventDefault();
                saveSettings();
            });

            // 非同期保存処理
            async function saveSettings() {
                var dialog = new PppDialog();

                // 保存ボタンをローディング状態に
                saveButton.classList.add('saving');
                var buttonIcon = saveButton.querySelector('i');
                var originalIconClass = buttonIcon ? buttonIcon.className : '';
                if (buttonIcon) {
                    buttonIcon.className = 'bi bi-arrow-repeat';
                }
                saveButton.disabled = true;

                try {
                    var formData = new FormData(settingsForm);

                    //WAF対策のためBASE64エンコード
                    formData.set("index_text", base65Encoding(document.querySelector("#index_text").value ?? ""));
                    formData.set("entry_text", base65Encoding(document.querySelector("#entry_text").value ?? ""));
                    formData.set("nsfw_text", base65Encoding(document.querySelector("#nsfw_text").value ?? ""));
                    formData.set("user_css", base65Encoding(document.querySelector("#user_css").value ?? ""));

                    var response = await fetch(BASE_URL + '/setting', {
                        method: 'POST',
                        body: formData
                    });

                    var result;
                    try {
                        result = await response.json();
                    } catch (parseError) {
                        throw new Error('サーバーからの応答を解析できませんでした');
                    }

                    if (result.status === 'success') {
                        // 成功ダイアログを表示
                        await dialog.openAlert({
                            title: '保存完了',
                            message: '設定を保存しました。',
                            buttonText: 'OK'
                        });
                    } else {
                        // エラーダイアログを表示
                        var errorMessage = result.message || '設定の保存に失敗しました。';
                        await dialog.openAlert({
                            title: 'エラー',
                            message: errorMessage,
                            buttonText: '閉じる'
                        });
                    }

                } catch (error) {
                    console.error('Save error:', error);
                    // 通信エラーダイアログを表示
                    await dialog.openAlert({
                        title: 'エラー',
                        message: '通信エラーが発生しました。<br>ネットワーク接続を確認してください。',
                        buttonText: '閉じる'
                    });
                } finally {
                    // ボタンを元に戻す
                    saveButton.classList.remove('saving');
                    if (buttonIcon) {
                        buttonIcon.className = originalIconClass;
                    }
                    saveButton.disabled = false;
                }
            }

            function base65Encoding(str) {
                const utf8Bytes = new TextEncoder().encode(str);
                const base64String = btoa(String.fromCharCode(...utf8Bytes));
                return base64String;
            }

        })();
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            class SyntaxEditor {
                constructor(textarea) {
                    this.textarea = textarea;
                    this.container = null;
                    this.backdrop = null;
                    this.highlights = null;

                    this.init();
                }

                init() {
                    // Create container and backdrop
                    this.container = document.createElement('div');
                    this.container.className = 'syntax-editor-container';

                    this.backdrop = document.createElement('div');
                    this.backdrop.className = 'syntax-backdrop';

                    this.highlights = document.createElement('div');
                    this.highlights.className = 'syntax-highlights';

                    this.backdrop.appendChild(this.highlights);

                    // Style syncing
                    this.syncStyles();

                    // Wrap textarea
                    this.textarea.parentNode.insertBefore(this.container, this.textarea);
                    this.container.appendChild(this.backdrop);
                    this.container.appendChild(this.textarea);

                    // Wrap toggle button
                    this.wrapEnabled = this.textarea.getAttribute('wrap') !== 'off';
                    this.wrapToggle = document.createElement('button');
                    this.wrapToggle.type = 'button';
                    this.wrapToggle.className = 'syntax-wrap-toggle' + (this.wrapEnabled ? ' wrap-on' : '');
                    this.wrapToggle.title = '折り返し切替';
                    this.wrapToggle.innerHTML = '<i class="bi bi-text-wrap"></i>';
                    this.wrapToggle.addEventListener('click', (e) => {
                        e.preventDefault();
                        this.toggleWrap();
                    });
                    this.container.appendChild(this.wrapToggle);

                    // Event listeners
                    this.textarea.addEventListener('input', () => this.update());

                    // Use requestAnimationFrame for smoother scroll sync
                    const syncLoop = () => {
                        this.syncScroll();
                        requestAnimationFrame(syncLoop);
                    };
                    syncLoop();

                    // Initial update
                    this.update();

                    // Window resize might change styles/sizes
                    window.addEventListener('resize', () => {
                        this.syncStyles();
                        this.update();
                    });
                }

                syncStyles() {
                    const style = window.getComputedStyle(this.textarea);

                    const props = [
                        'fontFamily', 'fontSize', 'fontWeight', 'lineHeight',
                        'letterSpacing', 'whiteSpace', 'wordBreak', 'wordWrap',
                        'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft',
                        'borderTopWidth', 'borderRightWidth', 'borderBottomWidth', 'borderLeftWidth',
                        'borderTopStyle', 'borderRightStyle', 'borderBottomStyle', 'borderLeftStyle',
                        'tabSize', 'textIndent', 'textTransform'
                    ];

                    props.forEach(prop => {
                        this.backdrop.style[prop] = style[prop];
                    });

                    // Add buffer to padding-bottom
                    const pb = parseFloat(style.paddingBottom) || 0;
                    this.backdrop.style.paddingBottom = (pb + 50) + 'px';

                    // Specifically sync highlight text styles to match
                    this.highlights.style.fontFamily = style.fontFamily;
                    this.highlights.style.fontSize = style.fontSize;
                    this.highlights.style.lineHeight = style.lineHeight;
                    // Critical for wrap="off" support
                    this.highlights.style.whiteSpace = style.whiteSpace;
                    this.highlights.style.wordWrap = style.wordWrap;
                    this.highlights.style.tabSize = style.tabSize;

                    this.highlights.style.borderColor = "#ffffff00";
                }

                syncScroll() {
                    this.highlights.style.transform = `translate(${-this.textarea.scrollLeft}px, ${-this.textarea.scrollTop}px)`;
                }

                update() {
                    let text = this.textarea.value;
                    const syntaxType = this.textarea.getAttribute('data-syntax-type') || 'default';

                    // HTML escape
                    text = text.replace(/&/g, '&amp;')
                        .replace(/</g, '&lt;')
                        .replace(/>/g, '&gt;');

                    // Apply highlighting based on syntax type
                    if (syntaxType === 'css') {
                        // CSS syntax highlighting
                        // Comments /* ... */
                        text = text.replace(/(\/\*[\s\S]*?\*\/)/g, '<span class="syntax-comment">$1</span>');

                        // Properties (word followed by colon)
                        text = text.replace(/([a-zA-Z-]+)(\s*:)/g, '<span class="syntax-property">$1</span>$2');

                        // Selectors (before { and not inside {})
                        text = text.replace(/^([^{}\/]*?)(\{)/gm, function(match, selector, brace) {
                            return '<span class="syntax-selector">' + selector + '</span>' + brace;
                        });

                        // Values with units (numbers followed by units)
                        text = text.replace(/(\d+)(px|em|rem|%|vh|vw|pt|s|ms)/g, '<span class="syntax-value">$1$2</span>');

                        // Color values
                        text = text.replace(/(#[0-9a-fA-F]{3,6})/g, '<span class="syntax-color">$1</span>');

                        // Strings
                        text = text.replace(/(&quot;[^&]*?&quot;|'[^']*?')/g, '<span class="syntax-string">$1</span>');
                    } else {
                        // Default (PPP template) syntax highlighting
                        text = text.replace(/(&lt;.*?&gt;)/g, '<span class="syntax-tag">$1</span>');
                        text = text.replace(/(\{.*?\})/g, '<span class="syntax-var">$1</span>');
                    }

                    // Handle trailing newlines
                    if (text.endsWith('\n')) {
                        text += '&nbsp;';
                    }

                    this.highlights.innerHTML = text;
                }

                toggleWrap() {
                    this.wrapEnabled = !this.wrapEnabled;
                    if (this.wrapEnabled) {
                        this.textarea.removeAttribute('wrap');
                        this.textarea.style.whiteSpace = 'pre-wrap';
                        this.textarea.style.overflowX = 'auto';
                        this.backdrop.style.whiteSpace = 'pre-wrap';
                        this.backdrop.style.wordWrap = 'break-word';
                        this.highlights.style.whiteSpace = 'pre-wrap';
                        this.highlights.style.wordWrap = 'break-word';
                        this.wrapToggle.classList.add('wrap-on');
                    } else {
                        this.textarea.setAttribute('wrap', 'off');
                        this.textarea.style.whiteSpace = 'pre';
                        this.textarea.style.overflowX = 'scroll';
                        this.backdrop.style.whiteSpace = 'pre';
                        this.backdrop.style.wordWrap = 'normal';
                        this.highlights.style.whiteSpace = 'pre';
                        this.highlights.style.wordWrap = 'normal';
                        this.wrapToggle.classList.remove('wrap-on');
                    }
                    this.syncStyles();
                    this.update();
                }
            }

            // Initialize all editors
            const textareas = document.querySelectorAll('textarea[data-syntax-editor]');
            textareas.forEach(textarea => {
                new SyntaxEditor(textarea);
            });
        });
    </script>

    <!-- アイコン選択ダイアログ スクリプト -->
    <script>
        (function() {
            'use strict';

            // アイコン選択ダイアログの状態管理
            const IconSelector = {
                overlay: null,
                currentRow: null,
                selectedIcon: null,
                selectedFile: null,
                uploadedImageData: null,

                init() {
                    this.overlay = document.getElementById('icon_select_dialog');
                    if (!this.overlay) return;

                    this.bindEvents();
                },

                bindEvents() {
                    // アイコン選択ボタンのクリック
                    document.querySelectorAll('.sns-icon-select-btn').forEach(btn => {
                        btn.addEventListener('click', (e) => {
                            e.preventDefault();
                            this.openDialog(btn.dataset.row);
                        });
                    });

                    // ダイアログ閉じるボタン
                    const closeBtn = document.getElementById('icon-dialog-close');
                    if (closeBtn) {
                        closeBtn.addEventListener('click', () => this.closeDialog());
                    }

                    // オーバーレイクリックで閉じる
                    this.overlay.addEventListener('click', (e) => {
                        if (e.target === this.overlay) {
                            this.closeDialog();
                        }
                    });

                    // ESCキーで閉じる
                    document.addEventListener('keydown', (e) => {
                        if (e.key === 'Escape' && this.overlay.classList.contains('active')) {
                            this.closeDialog();
                        }
                    });

                    // アイコングリッドのクリック
                    document.querySelectorAll('.icon-grid-item').forEach(item => {
                        item.addEventListener('click', () => this.selectIcon(item));
                    });

                    // アップロードゾーン
                    const uploadZone = document.getElementById('icon-upload-zone');
                    const uploadInput = document.getElementById('icon-upload-input');

                    if (uploadZone && uploadInput) {
                        uploadZone.addEventListener('click', () => uploadInput.click());

                        uploadZone.addEventListener('dragover', (e) => {
                            e.preventDefault();
                            uploadZone.classList.add('dragover');
                        });

                        uploadZone.addEventListener('dragleave', () => {
                            uploadZone.classList.remove('dragover');
                        });

                        uploadZone.addEventListener('drop', (e) => {
                            e.preventDefault();
                            uploadZone.classList.remove('dragover');
                            const files = e.dataTransfer.files;
                            if (files.length > 0) {
                                this.handleFileUpload(files[0]);
                            }
                        });

                        uploadInput.addEventListener('change', (e) => {
                            if (e.target.files.length > 0) {
                                this.handleFileUpload(e.target.files[0]);
                            }
                        });
                    }

                    // クリアボタン
                    const clearBtn = document.getElementById('icon-btn-clear');
                    if (clearBtn) {
                        clearBtn.addEventListener('click', () => this.clearSelection());
                    }

                    // 確定ボタン
                    const confirmBtn = document.getElementById('icon-btn-confirm');
                    if (confirmBtn) {
                        confirmBtn.addEventListener('click', () => this.confirmSelection());
                    }
                },

                openDialog(rowIndex) {
                    this.currentRow = rowIndex;
                    this.selectedIcon = null;
                    this.selectedFile = null;
                    this.uploadedImageData = null;

                    // 現在の値を取得
                    const row = document.querySelector(`.sns-link-row[data-row-index="${rowIndex}"]`);
                    if (row) {
                        const currentValue = row.querySelector('.sns-icon-value').value;
                        if (currentValue && currentValue.startsWith('fa-')) {
                            // 既存のアイコンを選択状態にする
                            const iconItem = document.querySelector(`.icon-grid-item[data-icon="${currentValue}"]`);
                            if (iconItem) {
                                this.selectIcon(iconItem);
                            }
                        }
                    }

                    // プレビューをリセット
                    this.updatePreview();

                    // ダイアログを表示
                    this.overlay.classList.add('active');
                    document.body.style.overflow = 'hidden';
                },

                closeDialog() {
                    this.overlay.classList.remove('active');
                    document.body.style.overflow = '';

                    // 選択状態をリセット
                    document.querySelectorAll('.icon-grid-item').forEach(item => {
                        item.classList.remove('selected');
                    });
                },

                selectIcon(item) {
                    // 他の選択を解除
                    document.querySelectorAll('.icon-grid-item').forEach(i => {
                        i.classList.remove('selected');
                    });

                    // 選択状態にする
                    item.classList.add('selected');
                    this.selectedIcon = item.dataset.icon;
                    this.selectedFile = null;
                    this.uploadedImageData = null;

                    this.updatePreview();
                },

                handleFileUpload(file) {
                    // ファイルサイズチェック (2MB)
                    if (file.size > 2 * 1024 * 1024) {
                        alert('ファイルサイズは2MB以下にしてください');
                        return;
                    }

                    // 画像ファイルチェック
                    if (!file.type.startsWith('image/')) {
                        alert('画像ファイルを選択してください');
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = (e) => {
                        this.uploadedImageData = e.target.result;
                        this.selectedFile = file;
                        this.selectedIcon = null;

                        // アイコン選択を解除
                        document.querySelectorAll('.icon-grid-item').forEach(item => {
                            item.classList.remove('selected');
                        });

                        this.updatePreview();
                    };
                    reader.readAsDataURL(file);
                },

                updatePreview() {
                    const previewBox = document.getElementById('icon-preview-box');
                    const previewLabel = document.getElementById('icon-preview-label');

                    if (!previewBox || !previewLabel) return;

                    if (this.selectedIcon) {
                        previewBox.innerHTML = `<i class="${this.selectedIcon}"></i>`;
                        previewLabel.textContent = this.selectedIcon.replace('fa-brands ', '').replace('fa-solid ', '');
                    } else if (this.uploadedImageData) {
                        previewBox.innerHTML = `<img src="${this.uploadedImageData}" alt="preview">`;
                        previewLabel.textContent = this.selectedFile ? this.selectedFile.name : 'アップロード画像';
                    } else {
                        previewBox.innerHTML = '<i class="bi bi-question-lg" style="color:var(--text-light);"></i>';
                        previewLabel.textContent = '未選択';
                    }
                },

                clearSelection() {
                    this.selectedIcon = null;
                    this.selectedFile = null;
                    this.uploadedImageData = null;

                    document.querySelectorAll('.icon-grid-item').forEach(item => {
                        item.classList.remove('selected');
                    });

                    this.updatePreview();
                },

                confirmSelection() {
                    if (this.currentRow === null) return;

                    const row = document.querySelector(`.sns-link-row[data-row-index="${this.currentRow}"]`);
                    if (!row) return;

                    const preview = row.querySelector('.sns-icon-preview');
                    const hiddenInput = row.querySelector('.sns-icon-value');
                    const fileInput = row.querySelector('.sns-icon-file');

                    if (this.selectedIcon) {
                        // FontAwesomeアイコンの場合
                        preview.innerHTML = `<i class="${this.selectedIcon}"></i>`;
                        preview.classList.add('has-icon');
                        hiddenInput.value = this.selectedIcon;

                        // ファイル入力をクリア
                        if (fileInput) fileInput.value = '';

                    } else if (this.uploadedImageData && this.selectedFile) {
                        // アップロード画像の場合
                        preview.innerHTML = `<img src="${this.uploadedImageData}" alt="icon">`;
                        preview.classList.add('has-icon');

                        // DataTransferを使ってファイル入力に設定
                        const dataTransfer = new DataTransfer();
                        dataTransfer.items.add(this.selectedFile);
                        fileInput.files = dataTransfer.files;

                        // hidden inputにはdata URLを一時的に設定
                        hiddenInput.value = "UPLOADIMAGE"; //this.uploadedImageData;

                    } else {
                        // クリアの場合
                        preview.innerHTML = '';
                        preview.classList.remove('has-icon');
                        hiddenInput.value = '';
                        if (fileInput) fileInput.value = '';
                    }

                    this.closeDialog();
                }
            };

            // DOM読み込み完了時に初期化
            document.addEventListener('DOMContentLoaded', () => {
                IconSelector.init();
            });
        })();
    </script>
    <script>
        //Ctrl + Sによる保存に対応
        document.addEventListener("keydown", function(e) {
            if (e.ctrlKey && (e.key == "s")) {
                e.preventDefault();
                Q('#saveButton').click();
            }
        });
    </script>


</body>

</html>