<?php
?>

<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{PPP:page_title}</title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Noto+Sans+JP:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/vender/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/dialog2.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_common.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_list.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_messages.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/systemheader.css">
    <script>
        const BASE_URL = "{PPP:base_url}";
    </script>
    <script src="{PPP:site_url}/system_resource/script/dialog2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/common2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/admin2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_common.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_list.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_messages_modal.js" defer></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            ConsoleList.init({
                deletePath: '/api/v2/messages',
                listPath: '/console/messages',
                checkboxSelector: '.message-checkbox',
                deleteConfirmMessage: '件のメッセージを削除しますか？この操作は取り消せません。',
            });
        });
    </script>
</head>

<body>

    <div class="d-flex">
        <!-- サイドバーオーバーレイ（モバイル用） -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- サイドバー -->
        <nav id="sidebar">
            <div class="sidebar-header">
                <span class="sidebar-title">管理コンソール</span>
                <button id="toggleSidebar" title="サイドバー切替">
                    <i class="bi bi-list"></i>
                </button>
            </div>

            <ul class="nav">
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/console">
                        <i class="bi bi-house-fill"></i>
                        <span class="menu-text">ダッシュボード</span>
                    </a>
                </li>

                <div class="nav-section-title">コンテンツ</div>

                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/console/articles">
                        <i class="bi bi-file-text-fill"></i>
                        <span class="menu-text">記事一覧</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/edit">
                        <i class="bi bi-pencil-square"></i>
                        <span class="menu-text">新規作成</span>
                    </a>
                </li>

                <div class="nav-section-title">コミュニケーション</div>

                <li class="nav-item">
                    <a class="nav-link active" href="{PPP:base_url}/console/messages">
                        <i class="bi bi-envelope-fill"></i>
                        <span class="menu-text">メッセージ</span>
                        {PPP IF:unread_count}
                        <span class="badge">{PPP:unread_count}</span>
                        {PPP ENDIF}
                    </a>
                </li>

                <div class="nav-section-title">設定</div>

                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/setting">
                        <i class="bi bi-gear-fill"></i>
                        <span class="menu-text">サイト設定</span>
                    </a>
                </li>
            </ul>

            <div style="flex: 1;"></div>

            <ul class="nav" style="border-top: 1px solid var(--border-light); margin-top: auto;">
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:site_url}/" target="_blank">
                        <i class="bi bi-box-arrow-up-right"></i>
                        <span class="menu-text">サイトを表示</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/logout">
                        <i class="bi bi-box-arrow-right"></i>
                        <span class="menu-text">ログアウト</span>
                    </a>
                </li>
            </ul>
        </nav>

        <!-- メインコンテンツ -->
        <main id="content">
            <!-- システムヘッダー -->
            <div class="system_header">
                <a id="back_link" href="{PPP:site_url}/" class="header_link_exit">&lt; TOP</a>
                <div class="header_option_link_area">
                    <span id="notification_link"><i id="notification" class="fa-regular fa-bell"></i></span>
                    <a id="setting_link" href="{PPP:base_url}/setting"><i class="fa-solid fa-gear"></i> 設定</a>
                    <a id="logout_link" href="{PPP:base_url}/logout">ログアウト</a>
                </div>
            </div>

            <div class="content-header">
                <div class="header-left d-flex align-items-center">
                    <button type="button" class="mobile-menu-btn" id="mobileMenuBtn" aria-label="メニューを開く">
                        <i class="bi bi-list"></i>
                    </button>
                    <div>
                        <h1>メッセージ</h1>
                        <p class="content-header-subtitle">受信したメッセージを管理</p>
                    </div>
                </div>
            </div>

            <div class="content-body">
                <!-- 検索・フィルターエリア -->
                <div class="filter-area">
                    <div class="filter-row">
                        <div class="search-box">
                            <i class="bi bi-search"></i>
                            <input type="text" id="searchInput" placeholder="名前、メール、メッセージで検索..." value="{PPP:searchs}">
                            <button type="button" class="clear-btn" id="searchClear">
                                <i class="bi bi-x-circle"></i>
                            </button>
                        </div>
                        <div class="sort-select">
                            <label for="sortType">並び替え</label>
                            <select id="sortType" name="sort_type">
                                <option value="0" <?= $sort_type_select[0] ?>>受信日時 ▽</option>
                                <option value="1" <?= $sort_type_select[1] ?>>受信日時 △</option>
                                <option value="2" <?= $sort_type_select[2] ?>>名前 ▽</option>
                                <option value="3" <?= $sort_type_select[3] ?>>名前 △</option>
                                <option value="4" <?= $sort_type_select[4] ?>>IPアドレス ▽</option>
                                <option value="5" <?= $sort_type_select[5] ?>>IPアドレス △</option>
                            </select>
                        </div>
                    </div>

                    <div class="filter-tags">
                        <span class="p-tag special" data-search=":unread"><i class="bi bi-envelope"></i> 未読のみ</span>
                    </div>
                </div>

                <!-- メッセージ一覧カード -->
                <div class="table-card">
                    {PPP IF:message}
                    <div class="empty-state">
                        <i class="bi bi-envelope-open"></i>
                        <h3>{PPP:message}</h3>
                        <p>新しいメッセージが届くとここに表示されます</p>
                    </div>
                    {PPP ELSE}
                    <div class="message-list" id="messageList">
                        {PPP LOOP:messages}
                        <div class="message-item-cover">
                            <div class="message-item {PPP IF:messages.read}read{PPP ELSE}unread{PPP ENDIF}" data-id="{PPP:messages.id}">
                                <input type="checkbox" class="message-checkbox" name="target[]" data-id="{PPP:messages.id}">
                                <div class="message-content">
                                    <div class="message-header">
                                        <span class="message-sender">{PPP:messages.name}</span>
                                        <span class="message-email">{PPP:messages.email}</span>
                                        <span class="message-date"><i class="bi bi-calendar3"></i> {PPP:messages.created_at}</span>
                                    </div>
                                    <p class="message-body">{PPP:messages.caption}</p>
                                    <div class="message-meta">
                                        <span><i class="bi bi-globe"></i> {PPP:messages.from_ip}</span>
                                    </div>
                                </div>
                                <div class="message-actions">
                                    <button type="button" class="btn btn-outline btn-sm view-message"
                                        data-id="{PPP:messages.id}"
                                        data-name="{PPP:messages.name}"
                                        data-email="{PPP:messages.email}"
                                        data-ip="{PPP:messages.from_ip}"
                                        data-date="{PPP:messages.created_at}"
                                        data-message="{PPP:messages.message}">
                                        <i class="bi bi-eye"></i>
                                        詳細
                                    </button>
                                </div>
                            </div>
                        </div>
                        {/PPP LOOP}
                    </div>

                    <div class="action-bar">
                        <div class="selection-info">
                            <span id="selectedCount">0</span> 件選択中
                        </div>
                        <button type="button" class="btn btn-danger btn-sm" id="deleteSelected" disabled>
                            <i class="bi bi-trash"></i>
                            選択したメッセージを削除
                        </button>
                    </div>
                    {PPP ENDIF}

                    <!-- ページネーション -->
                    <div class="pagination">
                        {PPP LOOP:pagination}
                        {PPP IF:pagination.is_current}
                        <span class="current">{PPP:pagination.index}</span>
                        {PPP ELSE}
                        <a href="{PPP:pagination.url}">{PPP:pagination.index}</a>
                        {PPP ENDIF}
                        {/PPP LOOP}
                    </div>
                </div>
            </div>

            <footer class="content-footer">
                <p>&copy; 2025 - Powered by PictPostPersonal</p>
            </footer>
        </main>
    </div>
    {PPP:csrf}
    <!-- メッセージ詳細モーダル -->
    <div class="message-detail-modal" id="messageDetailModal">
        <div class="message-detail-content">
            <div class="message-detail-header">
                <div class="message-detail-sender">
                    <div class="detail-value" id="detailDate"></div>
                    <div class="detail-value" id="detailName"></div>
                    <span class="detail-value" id="detailEmail"></span>
                    <span class="detail-value" id="detailIP"></span>
                </div>
                <button type="button" class="message-detail-close" id="closeModal">
                    <i class="bi bi-x-lg"></i>
                </button>
            </div>
            <div class="message-detail-body">
                <div class="detail-row">
                    <div class="detail-label">メッセージ</div>
                    <div class="detail-message" id="detailMessage"></div>
                </div>

            </div>

        </div>
    </div>


</body>

</html>