<?php
?>

<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{PPP:page_title}</title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Noto+Sans+JP:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/vender/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/dialog2.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_common.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_list.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_articles.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/systemheader.css">
    <script>
        const BASE_URL = "{PPP:base_url}";
    </script>
    <script src="{PPP:site_url}/system_resource/script/dialog2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/common2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/admin2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_common.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_list.js" defer></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            ConsoleList.init({
                deletePath: '/api/v2/articles',
                listPath: '/console/articles',
                checkboxSelector: '.article-checkbox',
                deleteConfirmMessage: '件の記事を削除しますか？この操作は取り消せません。'
            });
        });
    </script>
</head>

<body>

    <div class="d-flex">
        <!-- サイドバーオーバーレイ（モバイル用） -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- サイドバー -->
        <nav id="sidebar">
            <div class="sidebar-header">
                <span class="sidebar-title">管理コンソール</span>
                <button id="toggleSidebar" title="サイドバー切替">
                    <i class="bi bi-list"></i>
                </button>
            </div>

            <ul class="nav">
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/console">
                        <i class="bi bi-house-fill"></i>
                        <span class="menu-text">ダッシュボード</span>
                    </a>
                </li>

                <div class="nav-section-title">コンテンツ</div>

                <li class="nav-item">
                    <a class="nav-link active" href="{PPP:base_url}/console/articles">
                        <i class="bi bi-file-text-fill"></i>
                        <span class="menu-text">記事一覧</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/edit">
                        <i class="bi bi-pencil-square"></i>
                        <span class="menu-text">新規作成</span>
                    </a>
                </li>

                <div class="nav-section-title">コミュニケーション</div>

                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/console/messages">
                        <i class="bi bi-envelope-fill"></i>
                        <span class="menu-text">メッセージ</span>
                        {PPP IF:messages}
                        <span class="badge">{PPP:messages}</span>
                        {PPP ENDIF}
                    </a>
                </li>

                <div class="nav-section-title">設定</div>

                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/setting">
                        <i class="bi bi-gear-fill"></i>
                        <span class="menu-text">サイト設定</span>
                    </a>
                </li>
            </ul>

            <div style="flex: 1;"></div>

            <ul class="nav" style="border-top: 1px solid var(--border-light); margin-top: auto;">
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:site_url}/" target="_blank">
                        <i class="bi bi-box-arrow-up-right"></i>
                        <span class="menu-text">サイトを表示</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/logout">
                        <i class="bi bi-box-arrow-right"></i>
                        <span class="menu-text">ログアウト</span>
                    </a>
                </li>
            </ul>
        </nav>

        <!-- メインコンテンツ -->
        <main id="content">
            <!-- システムヘッダー -->
            <div class="system_header">
                <a id="back_link" href="{PPP:site_url}/" class="header_link_exit">&lt; TOP</a>
                <div class="header_option_link_area">
                    <span id="notification_link"><i id="notification" class="fa-regular fa-bell"></i></span>
                    <a id="setting_link" href="{PPP:base_url}/setting"><i class="fa-solid fa-gear"></i> 設定</a>
                    <a id="logout_link" href="{PPP:base_url}/logout">ログアウト</a>
                </div>
            </div>

            <div class="content-header">
                <div class="header-left d-flex align-items-center">
                    <button type="button" class="mobile-menu-btn" id="mobileMenuBtn" aria-label="メニューを開く">
                        <i class="bi bi-list"></i>
                    </button>
                    <div>
                        <h1>記事一覧</h1>
                        <p class="content-header-subtitle">すべての記事を管理</p>
                    </div>
                </div>
                <div class="header-actions">
                    <a href="{PPP:site_url}/edit" class="btn btn-primary btn-big">
                        <i class="bi bi-plus-lg"></i>
                        新規作成
                    </a>
                </div>
            </div>

            <div class="content-body">
                <!-- 検索・フィルターエリア -->
                <div class="filter-area">
                    <div class="filter-row">
                        <div class="search-box">
                            <i class="bi bi-search"></i>
                            <input type="text" id="searchInput" placeholder="タイトル、本文、タグで検索..." value="{PPP:searchs}">
                            <button type="button" class="clear-btn" id="searchClear">
                                <i class="bi bi-x-circle"></i>
                            </button>
                        </div>
                        <div class="sort-select">
                            <label for="sortType">並び替え</label>
                            <select id="sortType" name="sort_type">
                                <option value="0" <?= $sort_type_select[0] ?>>作成日時 ▽</option>
                                <option value="1" <?= $sort_type_select[1] ?>>作成日時 △</option>
                                <option value="2" <?= $sort_type_select[2] ?>>更新日時 ▽</option>
                                <option value="3" <?= $sort_type_select[3] ?>>更新日時 △</option>
                                {PPP IF:settings["use_feedback"]}
                                <option value="4" <?= $sort_type_select[4] ?>>閲覧数 ▽</option>
                                <option value="5" <?= $sort_type_select[5] ?>>閲覧数 △</option>
                                <option value="6" <?= $sort_type_select[6] ?>>いいね数 ▽</option>
                                <option value="7" <?= $sort_type_select[7] ?>>いいね数 △</option>
                                {PPP ENDIF}
                            </select>
                        </div>
                    </div>

                    <div class="tag-cloud">
                        <span class="tag-cloud-title">タグで絞り込み</span>
                        {PPP:tagcloud_nolink}{PPP:tagcloud_nolink_more}
                        <span class="p-tag special" data-search=":fix"><i class="bi bi-pin-angle"></i> 固定ページ</span>
                        <span class="p-tag special" data-search=":draft"><i class="bi bi-file-earmark"></i> 下書き</span>
                        <span class="p-tag special" data-search=":hidden"><i class="bi bi-eye-slash"></i> 非表示</span>
                        <span class="p-tag special" data-search=":pin"><i class="bi bi-pin"></i> ピン留め</span>
                        <span class="p-tag special" data-search=":nsfw"><i class="bi bi-exclamation-triangle"></i> NSFW</span>
                    </div>
                </div>

                <!-- 記事一覧カード -->
                <div class="table-card">
                    {PPP IF:message}
                    <div class="empty-state">
                        <i class="bi bi-file-earmark-text"></i>
                        <h3>{PPP:message}</h3>
                        <p>新しい記事を作成してみましょう</p>
                        <a href="{PPP:base_url}/edit" class="btn btn-primary">
                            <i class="bi bi-plus-lg"></i>
                            記事を作成
                        </a>
                    </div>
                    {PPP ELSE}
                    <div class="article-list" id="articleList">
                        {PPP LOOP:articles}
                        <div class="article-item" data-id="{PPP:articles.id}">
                            <input type="checkbox" class="article-checkbox" name="target[]" data-id="{PPP:articles.id}">
                            <div class="article-thumbnail">
                                {PPP IF:articles.thumbnail}
                                <img src="{PPP:articles.thumbnail}" alt="">
                                {PPP ELSE}
                                <div class="no-image"><i class="bi bi-image"></i></div>
                                {PPP ENDIF}
                            </div>
                            <div class="article-info">
                                <a href="{PPP:base_url}/edit?id={PPP:articles.id}" class="article-title">{PPP:articles.title}</a>
                                <p class="article-caption">{PPP:articles.caption}</p>
                                <div class="article-meta">
                                    <span><i class="bi bi-calendar3"></i> {PPP:articles.created_at}</span>
                                    {PPP IF:settings['use_feedback']}
                                    <span><i class="bi bi-eye"></i> {PPP:articles.views}</span>
                                    <span><i class="bi bi-heart"></i> {PPP:articles.like}</span>
                                    {/PPP IF}
                                </div>
                            </div>
                            <div class="article-actions">
                                <a href="{PPP:base_url}/edit?id={PPP:articles.id}" class="btn btn-outline btn-sm">
                                    <i class="bi bi-pencil"></i>
                                    編集
                                </a>
                                <a href="{PPP:site_url}/log/{PPP:articles.id}" target="_blank" class="btn btn-outline btn-sm">
                                    <i class="bi bi-eye"></i>
                                    表示
                                </a>
                            </div>
                        </div>
                        {/PPP LOOP}
                    </div>
                    {PPP:csrf}
                    <div class="action-bar">
                        <div class="selection-info">
                            <span id="selectedCount">0</span> 件選択中
                        </div>
                        <button type="button" class="btn btn-danger btn-sm" id="deleteSelected" disabled>
                            <i class="bi bi-trash"></i>
                            選択した記事を削除
                        </button>
                    </div>
                    {PPP ENDIF}

                    <!-- ページネーション -->
                    <div class="pagination">
                        {PPP LOOP:pagination}
                        {PPP IF:pagination.is_current}
                        <span class="current">{PPP:pagination.index}</span>
                        {PPP ELSE}
                        <a href="{PPP:pagination.url}">{PPP:pagination.index}</a>
                        {PPP ENDIF}
                        {/PPP LOOP}
                    </div>
                </div>
            </div>

            <footer class="content-footer">
                <p>&copy; 2025 - Powered by PictPostPersonal</p>
            </footer>
        </main>
    </div>


</body>

</html>