<?php
?>

<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{PPP:page_title}</title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Noto+Sans+JP:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/vender/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/dialog2.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_common.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/console2_dashboard.css">
    <link rel="stylesheet" href="{PPP:site_url}/system_resource/css/systemheader.css">
    <script>
        const BASE_URL = "{PPP:base_url}";
    </script>
    <script src="{PPP:site_url}/system_resource/script/dialog2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/common2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/admin2.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_common.js" defer></script>
    <script src="{PPP:site_url}/system_resource/script/console2_dashboard.js" defer></script>
</head>

<body>

    <div class="d-flex">
        <!-- サイドバーオーバーレイ（モバイル用） -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- サイドバー -->
        <nav id="sidebar">
            <div class="sidebar-header">
                <span class="sidebar-title">管理コンソール</span>
                <button id="toggleSidebar" title="サイドバー切替">
                    <i class="bi bi-list"></i>
                </button>
            </div>

            <ul class="nav">
                <li class="nav-item">
                    <a class="nav-link active" href="{PPP:base_url}/console">
                        <i class="bi bi-house-fill"></i>
                        <span class="menu-text">ダッシュボード</span>
                    </a>
                </li>

                <div class="nav-section-title">コンテンツ</div>

                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/console/articles">
                        <i class="bi bi-file-text-fill"></i>
                        <span class="menu-text">記事一覧</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/edit">
                        <i class="bi bi-pencil-square"></i>
                        <span class="menu-text">新規作成</span>
                    </a>
                </li>

                <div class="nav-section-title">コミュニケーション</div>

                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/console/messages">
                        <i class="bi bi-envelope-fill"></i>
                        <span class="menu-text">メッセージ</span>
                        {PPP IF:messages}
                        <span class="badge">{PPP:messages}</span>
                        {PPP ENDIF}
                    </a>
                </li>

                <div class="nav-section-title">設定</div>

                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/setting">
                        <i class="bi bi-gear-fill"></i>
                        <span class="menu-text">サイト設定</span>
                    </a>
                </li>
            </ul>

            <div style="flex: 1;"></div>

            <ul class="nav" style="border-top: 1px solid var(--border-light); margin-top: auto;">
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:site_url}/" target="_blank">
                        <i class="bi bi-box-arrow-up-right"></i>
                        <span class="menu-text">サイトを表示</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{PPP:base_url}/logout">
                        <i class="bi bi-box-arrow-right"></i>
                        <span class="menu-text">ログアウト</span>
                    </a>
                </li>
            </ul>
        </nav>

        <!-- メインコンテンツ -->
        <main id="content">
            <!-- ヘッダー -->
            <div class="system_header system_header_light">
                <a id="back_link" href="{PPP:site_url}/" class="header_link_exit">&lt; TOP</a>
                <div class="header_option_link_area">
                    <span id="notification_link"><i id="notification" class="fa-regular fa-bell font-size:1em"></i></span>
                    <a id="setting_link" href="{PPP:base_url}/setting"><i class="fa-solid fa-gear font-size:1em"></i>設定</a>
                    <a id="logout_link" href="{PPP:base_url}/logout">ログアウト</a>
                </div>
            </div>
            <div class="content-header">
                <div class="header-left d-flex align-items-center">
                    <!-- モバイルメニューボタン -->
                    <button type="button" class="mobile-menu-btn" id="mobileMenuBtn" aria-label="メニューを開く">
                        <i class="bi bi-list"></i>
                    </button>
                    <div>
                        <h1>ダッシュボード</h1>
                        <p class="content-header-subtitle">サイトの概要とアクティビティ</p>
                    </div>
                </div>
                <div class="header-actions">
                    <a href="{PPP:site_url}/edit" class="btn btn-primary btn-big">
                        <i class="bi bi-plus-lg"></i>
                        新規作成
                    </a>
                </div>
            </div>

            <div class="content-body">
                <!-- 統計カード -->
                <div class="stats-grid">
                    {PPP IF:settings['use_feedback']}
                    <div class="stat-card">
                        <div class="stat-icon likes">
                            <i class="bi bi-heart-fill"></i>
                        </div>
                        <div class="stat-content">
                            <p class="stat-label">今日のLike数</p>
                            <p class="stat-value" id="likes-today">{PPP:today_likes}</p>
                        </div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon week">
                            <i class="bi bi-graph-up"></i>
                        </div>
                        <div class="stat-content">
                            <p class="stat-label">1週間のLike数</p>
                            <p class="stat-value" id="likes-week">{PPP:week_likes}</p>
                            <p class="stat-hint" id="week-range">{PPP:week_likes_span}</p>
                        </div>
                    </div>
                    {PPP ENDIF}

                    <div class="stat-card">
                        <div class="stat-icon messages">
                            <i class="bi bi-envelope-fill"></i>
                        </div>
                        <div class="stat-content">
                            <p class="stat-label">未読メッセージ</p>
                            <p class="stat-value" id="unread-messages">{PPP:messages}</p>
                            <p class="stat-hint">受信箱を確認してください</p>
                        </div>
                    </div>
                </div>

                <!-- 下書き一覧 -->
                <div class="table-card">
                    <div class="table-card-header">
                        <h2 class="table-card-title">
                            <i class="bi bi-file-earmark-text"></i>
                            下書き記事一覧
                        </h2>
                        <div class="table-actions">
                            <input id="search-drafts" type="search" placeholder="タイトルで検索..." class="form-control">
                            <a href="{PPP:site_url}/edit?status=draft" class="btn btn-primary btn-sm">
                                <i class="bi bi-plus-lg"></i>
                                新規下書き
                            </a>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>タイトル</th>
                                    <th>作成日時</th>
                                    <th>操作</th>
                                </tr>
                            </thead>
                            <tbody id="drafts-table">
                                {PPP LOOP:drafts}
                                <tr>
                                    <td data-label="タイトル">
                                        <a href="{PPP:base_url}/edit/{PPP:drafts.id}">
                                            <div class="table-title">{PPP:drafts.title}</div>
                                        </a>
                                    </td>
                                    <td data-label="作成日時" class="table-date">{PPP:drafts.created_at}</td>
                                    <td data-label="操作">
                                        <div class="table-actions-cell">
                                            <a href="{PPP:base_url}/edit/{PPP:drafts.id}" class="btn btn-outline btn-sm">
                                                <i class="bi bi-pencil"></i>
                                                編集
                                            </a>
                                            <button class="btn btn-outline btn-sm" data-action="delete" data-id="{PPP:drafts.id}">
                                                <i class="bi bi-trash"></i>
                                                削除
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                {/PPP LOOP}
                            </tbody>
                        </table>
                    </div>

                    <div id="no-drafts" class="empty-state" style="display: none;">
                        <i class="bi bi-file-earmark"></i>
                        <p>下書きはありません</p>
                    </div>
                </div>

                <!-- 最近の記事一覧 -->
                <div class="table-card">
                    <div class="table-card-header">
                        <h2 class="table-card-title">
                            <i class="bi bi-clock-history"></i>
                            最近の記事一覧
                        </h2>
                        <div class="table-actions">
                            <a href="{PPP:base_url}/console/articles" class="btn btn-secondary">
                                すべて表示
                                <i class="bi bi-arrow-right"></i>
                            </a>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>タイトル</th>
                                    <th>作成日時</th>
                                    <th>操作</th>
                                </tr>
                            </thead>
                            <tbody>
                                {PPP LOOP:articles}
                                <tr>
                                    <td data-label="タイトル">
                                        <a href="{PPP:base_url}/edit/{PPP:articles.id}">
                                            <div class="table-title">{PPP:articles.title}</div>
                                        </a>
                                    </td>
                                    <td data-label="作成日時" class="table-date">{PPP:articles.created_at}</td>
                                    <td data-label="操作">
                                        <div class="table-actions-cell">
                                            <a href="{PPP:base_url}/edit/{PPP:articles.id}" class="btn btn-outline btn-sm">
                                                <i class="bi bi-pencil"></i>
                                                編集
                                            </a>
                                            <a href="{PPP:site_url}/log/{PPP:articles.id}" target="_blank" class="btn btn-outline btn-sm">
                                                <i class="bi bi-eye"></i>
                                                表示
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                {/PPP LOOP}
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <footer class="content-footer">
                <p>&copy; 2025 - Powered by PictPostPersonal</p>
            </footer>
        </main>
    </div>


</body>

</html>