<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- meta -->
    {PPP INCLUDE:template2_meta_header.php}

    <!-- system header -->
    {PPP INCLUDE:template2_sys_header.php}

    <!-- template resouce -->
    <link rel="stylesheet" href="{PPP SITE_URL}/system_resource/css/recss.css">
    <link rel="stylesheet" href="{PPP THEME_URL}/css/styles.css">
    <link rel="stylesheet" href="{PPP:site_url}/user_resource/user.css">

    <style>
        .article-container {
            max-width: 900px;
            margin-top: 2rem;
            margin-bottom: 2rem;
            border-radius: 15px;
        }

        .section {
            margin-bottom: 1rem;
        }

        .tag {
            font-size: 0.8rem;
        }

        .global-header {
            margin-left: 0.5rem;
        }

        .header {
            margin-left: 0.5rem;
        }

        .control {
            text-align: center;
        }

        .section {
            margin-bottom: 1rem;
        }

        select {
            border: 1px solid #888;
            padding: 0.1rem 0.8rem;
            margin-left: 0.5rem;
            border-radius: 5px;
        }

        .search-list {
            margin-top: 2rem;
        }

        @scope(.search-list) {
            li {
                list-style: none;
            }

            div.list-item {
                font-size: 1rem;
                display: grid;
                grid-template-columns: var(--search-thumbnail-width, 150px) auto;
                grid-template-rows: 1rem 2rem auto;
                column-gap: 10px;
                margin: 0 2rem 1rem 2rem;
                max-height: calc(var(--search-thumbnail-height, 100px) + 50px);
                overflow: hidden;
            }

            .list-item-thumb {
                grid-column: 1;
                grid-row: span 3;
                margin-right: 0.5em;
                width: var(--search-thumbnail-width, 100px);
                height: var(--search-thumbnail-height, 100px);
                background-color: #999;
                overflow: hidden;
                background-size: cover;
                background-position: center center;
            }

            .list-item-thumb-in {
                position: relative;
                width: var(--search-thumbnail-width, 100px);
                height: var(--search-thumbnail-height, 100px);
                border: 1px solid #999;
            }

            .list-item-created-at {
                text-wrap: nowrap;
                grid-column: 2;
                font-size: 0.7em;
                margin-right: 1em;
            }

            .list-item-title {
                align-self: center;
                grid-column: 2;
                text-wrap: nowrap;
                line-height: 160%;
            }

            .list-item-caption {
                grid-column: 2;
                font-size: 0.8em;
                overflow: hidden;
                line-height: 140%;
                max-height: var(--search-thumbnail-height, 100px);
            }


            .list-item-thumb-image {
                width: 100%;
                height: 100%;
                object-fit: cover;
                object-position: center;
            }

            .list-item-thumb-title {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                display: grid;
                place-content: center;
            }
        }
    </style>
</head>

<body>
    {PPP:admin_header}
    <div class="global-header">
        <a href="{PPP:site_url}/">
            {PPP:site_title}
        </a>
    </div>
    <div class="header">
        <a href="" data-log-return>
            &lt; 戻る
        </a>
    </div>
    <div class="main-container article-container">
        <div class="main-contents">
            <form action="/search" method="get">
                <div class="control-area section">

                    <div class="p-search-input">
                        <button data-search><i class="p-search-button fa-solid fa-magnifying-glass"></i></button>
                        <input data-search-input type="input" onclick="this.select();" value="%{$searchs}" name="q">
                        <button data-search-clear><i class="p-search_clear_button fa-regular fa-circle-xmark"></i></button>
                    </div>

                </div>

                <div class="sort-control section">
                    <label for="sort-type">並び替え</label>
                    <select data-search-order class="sort-type" id="sort-type" name="sort-type">
                        <option value="0" {PPP:sort_type_select[0]}>作成日時 ▽</option>
                        <option value="1" {PPP:sort_type_select[1]}>作成日時 △</option>
                        <option value="2" {PPP:sort_type_select[2]}>更新日時 ▽</option>
                        <option value="3" {PPP:sort_type_select[3]}>更新日時 △</option>
                    </select>
                </div>
            </form>
            <div class="contents-area">
                {PPP IF:message}
                <div class="message-area">
                    {PPP:message}
                </div>
                {/PPP IF}
                <ul class="search-list">
                    {PPP LOOP:articles}
                    <li>
                        <div class="list-item log-link" data-log-link>
                            <a class='list-item-thumb log-link' href="{PPP:articles.url}">
                                <div class='list-item-thumb-in {PPP:articles.thumbnail_class}'>
                                    <img class='list-item-thumb-image' src="{ppp:articles.thumbnail_path}">
                                    <span class="list-item-thumb-title">{PPP:articles.thumbnail_title}</span>
                                </div>
                            </a>

                            <div class="list-item-created-at">{PPP:articles.created_at}</div>
                            <div class="list-item-title"><a href="{PPP:articles.url}">{PPP:articles.title}</a></div>
                            <div class="list-item-caption"><a href="{PPP:articles.url}">{PPP:articles.caption}</a></div>
                        </div>
                    </li>
                    {/PPP LOOP}
                </ul>
                {PPP INCLUDE:template2_parts_pagination.php}
            </div>
        </div>

        <div class="global-footer">
            {PPP:powered_info}
        </div>
    </div>
</body>

</html>