<?php
/*
*
*   template2_parts_pagination.php
*   ページ送りナビゲータ( < 1 2 3 4 5 >) を構築するためのテンプレートです。
*   
*   {PPP LOOP:pagination}～{/PPP LOOP} 内がページ数分繰り返し出力されます。
*
*   LOOP内では次の変数が使用できます。
*
*    index           : ページ番号インデックス
*    is_first        : このインデックスが先頭であるか(1であるか)
*    is_last         : このインデックスが末尾であるか(ページ数の最後の数字か)
*    is_page_first   : このインデックスがページ内先頭であるか (ページ内での先頭インデックスであるか。例：10ページ中、先頭省略により < 5 6 7 8 9 > となった場合の5であるか)
*    is_page_first   : このインデックスがページ内末尾であるか (ページ内での末尾インデックスであるか。例：10ページ中、末尾省略により < 1 2 3 4 5 > となった場合の5であるか)
*    is_current      : このインデックスが現在のページ番号であるか
*    
*
*/ ?>
<div class="pagination">
    {PPP LOOP:pagination}
    <?php $add_class = ''; ?>
    {PPP IF:pagination.is_first}<?php $add_class .= ' pagination_first'; ?>{PPP ENDIF}
    {PPP IF:pagination.is_last}<?php $add_class .= ' pagination_last'; ?>{PPP ENDIF}
    {PPP IF:pagination.is_page_first}<?php $add_class .= ' pagination_page_first'; ?>{PPP ENDIF}
    {PPP IF:pagination.is_page_last}<?php $add_class .= ' pagination_page_last'; ?>{PPP ENDIF}
    {PPP IF:pagination.is_current}
    <span class="pagination_index pagination_current {PPP:add_class}">{PPP:pagination.index}</span>
    {PPP ELSE}
    <a href="{PPP:pagination.url}" class="pagination_index {PPP:add_class}">{PPP:pagination.index}</a>
    {PPP ENDIF}
    {/PPP LOOP}
</div>