<div class="mail_form" style="width:80%;margin:0 auto 0 auto">
    <form method="post" name="inputForm" id="inputForm">
        <input type="hidden" name="mode" value="post">
        お名前<br>
        <input type="text" name="name" class="flat_input" style="width:30em;max-width:90%;"><br>
        メールアドレス<br>
        <input type="email" name="email" id="email" class="flat_input" style="width:30em;max-width:90%;"><br>
        コメント<br>
        <textarea name="comment" id="comment" class="flat_input" style="height:10em;width:30em;max-width:90%;"></textarea>
        <input type="hidden" name="return_message" value="コメントを受け付けました。">
        <div class="control" style="text-align:center">
            <input type="submit" value="送信" class="button" id="submit_mail">
        </div>
        <input type="text" name="title" style="font-size:0.4em;border:none;width:1em;height:1em;">
        {PPP:csrf}
    </form>
</div>
<script>
    document.addEventListener("DOMContentLoaded", async () => {

        async function postMail(form_data) {
            let url = `${BASE_URL}/api/v2/mail`;
            let method = "POST";
            try {
                const response = await fetch(url, {
                    method: method,
                    body: form_data
                });
                if (!response.ok) {
                    throw new Error("Network response was not ok");
                }
                return await response.json();
            } catch (error) {
                console.error("Error:", error);
                throw error;
            }
        }
        Q("#submit_mail").addEventListener("click", async function(e) {
            e.preventDefault();
            if (Q("#comment").value.trim() == "") {
                await showDialog("コメントを入力してください", "OK");
                return
            }
            let form_data = new FormData(Q("#inputForm"));
            postResult = await postMail(form_data);
            let dialogText = "<p>" + postResult.message + "</p>";
            let result = await showDialog(dialogText, "OK");
            if (postResult.success) {
                Q("#comment").value = "";
            }
        });
    });
</script>