<?php
/*
*   article_list_(style).php 
*   article_listを構築するのに使用されるテンプレートです。
*
*   {PPP LOOP:articles} ～ {PPP LOOPEN}内が該当記事数分繰り返し出力されます。
*
*   LOOP内では次の値が使用できます。
*   url             : 記事のURL
*   thumbnail_path  : サムネイル画像のパス
*   created_at      : 作成日時
*   updated_at      : 更新日時
*   title           : タイトル
*   thumbnail_title     : サムネイル用タイトル。画像がある場合は空。（かならずタイトルを出したい場合はtitleを使用してください）
*   caption         : 記事概要
*
*   ｛PPP INCLUDE:template2_parts_pagination.php｝によりページ送り( < 1 2 3 4 5 >) が表示されます。
*
*/
?>
<style>
    .test {
        flex-direction: column;
    }
</style>
<style>
    .article_list_thumbs ul {
        display: flex;
        flex-direction: row;
        justify-content: center;
        flex-wrap: wrap;
        list-style: none;
        padding: 0;
        margin: 0 0 2em 0;
        width: 100%;
    }

    .article_list_thumbs ul a {
        text-decoration: none;
        font-weight: 800;
    }

    .article_list_thumbs li {
        display: block;
        margin: 0.5em;
        padding: 10px 10px 1.5em 10px;
        width: calc(var(--thumbnail-width) + 20px);
        height: calc(var(--thumbnail-height) + 10px + 1.5em);
        overflow: hidden;
        line-height: 1.5em;

    }

    .article_list_thumbs .list_item_thumb_in {
        width: var(--thumbnail-width);
        height: var(--thumbnail-height);
        background-size: cover;
        background-position: center;
        border: 1px solid #777;
        margin: 0 auto 0 auto;
        display: grid;
        place-content: center;

    }

    .article_list_thumbs .list_item_thumb_text {
        display: flex;
        overflow: hidden;
        padding: 1em;
        width: var(--thumbnail-width);
        height: var(--thumbnail-height);
        justify-content: center;
        align-items: center;
        font-weight: 100;
    }

    /* NSFW関連表示 ブラーを加える */
    .article_list_thumbs .thumb_nsfw {
        position: relative;
        overflow: hidden;
        width: inherit;
        height: inherit;
        z-index: 0;
    }

    .article_list_thumbs .thumb_nsfw:before {
        content: '';
        width: inherit;
        height: inherit;
        background: inherit;
        position: absolute;
        top: -5px;
        bottom: -5px;
        left: -5px;
        right: -5px;
        filter: blur(6px);
        z-index: -1;
    }

    .article_list_thumbs .thumb_nsfw:after {
        position: absolute;
        width: 100%;
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
        content: '[NSFW]';
        color: #fff;
        z-index: -1;
        text-shadow: 1px 1px 0 #8b0000, -1px -1px 0 #8b0000,
            -1px 1px 0 #8b0000, 1px -1px 0 #8b0000,
            1px 0 0 #8b0000, -1px 0 0 #8b0000,
            0 1px 0 #8b0000, 0 -1px 0 #8b0000;
    }

    /* NSFW同意済みの場合はブラー解除 */
    .article_list_thumbs .thumb_nsfw.thumb_nsfw_consent:before {
        filter: initial;
    }
</style>
<div class="article_list_thumbs">
    <ul>
        {PPP LOOP:articles}
        <li>
            <div class="log_link list_item">
                <a class="list_item_thumb" href="{PPP:articles.url}">
                    <div class="list_item_thumb_in {PPP:articles.thumbnail_class}" style="background-image:url('{PPP:articles.raw_thumbnail_path}')"><span class="list_item_thumb_text">{PPP:articles.thumbnail_title}</span></div>
                </a>
            </div>
        </li>
        {/PPP LOOP}
    </ul>
    {PPP INCLUDE:template2_parts_pagination.php}
</div>