<style>
    @scope(.article-list-normal) {
        li {
            list-style: none;
        }

        div.list-item {
            font-size: 1em;
            display: grid;
            grid-template-columns: 2em min-content 8em 3em auto;
            grid-template-rows: 1em 2em auto;
            margin: 0 3em 1em 3em;
            max-height: 150px;
            overflow: hidden;
        }

        .list-item-thumb {
            grid-column: 2;
            grid-row: span 3;
            margin-right: 0.5em;
            width: var(--search-thumbnail-width, 100px);
            height: var(--search-thumbnail-height, 100px);
            background-color: #999;
            border: 1px solid #999;
            overflow: hidden;
            background-size: cover;
            background-position: center center;
        }

        .list-item-thumb-in {
            position: relative;
            width: var(--search-thumbnail-width, 100px);
            height: var(--search-thumbnail-height, 100px);
        }

        .list-item-created-at {
            text-wrap: nowrap;
            grid-column: 3;
            font-size: 0.7em;
            margin-right: 1em;
        }

        .list-item-views {
            grid-column: 4;
            font-size: 0.7em;
            text-wrap: nowrap;
            min-width: 3em;
        }

        .list-item-like {
            grid-column: 5;
            font-size: 0.7em;
            text-wrap: nowrap;
            min-width: 3em;
        }

        .list-item-title {
            align-self: center;
            grid-column: 3 / span 3;
            text-wrap: nowrap;
            line-height: 160%;
            text-overflow: ellipsis;
        }

        .list-item-caption {
            grid-column: 3 / span 3;
            font-size: 0.8em;
            overflow: hidden;
            line-height: 140%;
            max-height: var(--search-thumbnail-height, 100px);
            text-overflow: ellipsis;
        }


        .list-item-thumb-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            object-position: center;
        }

        .list-item-thumb-title {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: grid;
            place-content: center;
        }
    }
</style>
<div class="article-list article-list-normal">
    <ul>
        {PPP LOOP:articles}
        <li>
            <div class="list-item log-link" data-log-link>
                <a class='list-item-thumb log-link' href="{PPP:articles.url}">
                    <div class='list-item-thumb-in {PPP:articles.thumbnail_class}'>
                        <img class='list-item-thumb-image' src="{ppp:articles.thumbnail_path}">
                        <span class="list-item-thumb-title">{PPP:articles.thumbnail_title}</span>
                    </div>
                </a>

                <div class="list-item-created-at">{PPP:articles.created_at}</div>
                <div class="list-item-title"><a href="{PPP:articles.url}">{PPP:articles.title}</a></div>
                <div class="list-item-caption"><a href="{PPP:articles.url}">{PPP:articles.caption}</a></div>
            </div>
        </li>
        {/PPP LOOP}
    </ul>
    {PPP INCLUDE:template2_parts_pagination.php}
</div>