<?php

namespace pictpostpersonal\service;

use pictpostpersonal\renderer\ArticleRenderer;
use pictpostpersonal\model\Article;
use pictpostpersonal\Context;

class TemplateApiService
{

    private $article_service;
    private $db;
    private $setting;

    function __construct(Context $context)
    {
        $this->db = $context->getDb();
        $this->setting = $context->getSetting();
        $this->article_service = new ArticleRenderer($context);
    }

    public function formatArticle($id)
    {
        $article = new Article($this->db, $this->setting);
        $article_data = $article->getById($id);
        $artilce_data['content'] = $this->article_service->formatToList($article_data);

        $data = [
            'current' => $article_data,
            'next' => [],
            'prev' => [],
            'next_link' => '',
            'prev_link' => '',
            'manga_mode' => false,
            'nsfw_ans' => false
        ];
        $data['comment'] = preg_replace('/{([0-9]+)}/si', "\{{$id}-$1}", $data['comment']);
        $html = $this->article_service->createContents($data, $data['comment'], true, [0]);
        return $html;
    }
}
