<?php

namespace pictpostpersonal\model;


use pictpostpersonal\SQLiteCRUD;
use pictpostpersonal\SQL;


class ThemeSetting
{
    private \PDO $db;
    private SQLiteCRUD $sqlcrud;
    public $fields;
    public $field_info;

    function __construct($db)
    {
        $this->db = $db;
        $this->sqlcrud = new SQLiteCRUD($db);
    }

    public static function initialize(SQLiteCRUD $sql_crud)
    {
        $sql_crud->table('theme_settings')->createTable(
            [
                SQL::Id('id'),
                SQL::Text('theme_name'),
                SQL::Text('type'),
                SQL::Text('key'),
                SQL::Text('value')
            ]
        );
    }


    function saveAllThemeSettings(array $settings, bool $use_transaction = true)
    {
        if ($use_transaction) {
            $this->db->beginTransaction();
        }
        foreach ($settings as $theme => $data) {
            foreach ($data as $index => $field) {
                $this->SaveKeyValue($theme, $field['type'], $index, $field['value'] ?? '');
            }
        }
        if ($use_transaction) {
            $this->db->commit();
        }
    }
    public function loadAllThemeSettings(): array
    {
        $result = $this->sqlcrud->table('theme_settings')->fetch();
        foreach ($result as $item) {
            $this->fields[$item['theme_name']][$item['key']]['value'] = $item['value'];
            $this->fields[$item['theme_name']][$item['key']]['type'] = $item['type'];
        }
        return $this->fields ?? [];
    }

    function saveThemeSettings(string $theme_name, array $settings, bool $use_transaction = true)
    {
        $setting = $this->fields;
        if ($use_transaction) {
            $this->db->beginTransaction();
        }
        foreach ($settings as $field) {
            $this->SaveKeyValue($theme_name, $field['type'], $field['key'], $field['value']);
        }
        if ($use_transaction) {
            $this->db->commit();
        }
    }

    public function loadThemeSettings(string $theme_name = ''): array
    {
        if ($theme_name === '') {
            $result = $this->sqlcrud->table('theme_settings')->fetch();
        } else {
            $result = $this->sqlcrud->table('theme_settings')->where('Theme_Name = :ThemeName', ['ThemeName' => $theme_name])->fetch();
        }
        foreach ($result as $item) {
            $this->fields[$item['key']]['value'] = $item['value'];
            $this->fields[$item['key']]['type'] = $item['type'];
        }
        return $this->fields ?? [];
    }

    private function saveKeyValue($theme_name, $type, $key, $value)
    {

        $data = [
            'theme_name' => $theme_name,
            'type' => $type,
            'key' => $key,
            'value' => $value
        ];

        if ($this->sqlcrud->table('theme_settings')->where('theme_name = :theme_name and key = :key',  $data)->update($data) == 0) {
            $this->sqlcrud->table('theme_settings')->create($data);
        }
    }
}
