<?php

namespace pictpostpersonal\model;

use pictpostpersonal\Environment;
use pictpostpersonal\SQLiteCRUD;

class Tag
{
    private $db;

    function __construct($db)
    {
        $this->db = $db;
    }

    function createTagCloud()
    {
        $crud = new SQLiteCRUD($this->db);
        $records = $crud->rawQuery('select tags from articles order by created_at desc', []);
        $base_url = BASE_URL;
        // タグをカウントするための連想配列
        $tag_counts = array();
        // 各レコードについて、タグをスペース区切りで分割してカウント
        foreach ($records as $row) {
            $tag = trim($row['tags'] ?? '');
            $tags = explode(' ', $tag);
            foreach ($tags as $tag) {
                if ($tag != '') {
                    if (array_key_exists($tag, $tag_counts)) {
                        $tag_counts[$tag]++;
                    } else {
                        $tag_counts[$tag] = 1;
                    }
                }
            }
        }
        // カウント結果を降順にソート
        arsort($tag_counts);

        // タグクラウドを出力
        $tagcloud_links = '<ul class="p-tag-cloud">';
        $tagcloud_links_more = '<ul class="p-tag-cloud tag-cloud-more" style="display: none;">';
        $tagcloud_nolink_sys = '<ul class="p-tag-cloud">';
        $tagcloud_nolink_more_sys = '<ul class="p-tag-cloud tag-cloud-more" style="display: none;">';
        $tagcloud_nolink = '<ul class="p-tag-cloud">';
        $tagcloud_nolink_more = '<ul class="p-tag-cloud  tag-cloud-more" style="display: none;">';

        $tagcloud_list = '';
        $idx = 0;
        $cnt = 0;
        foreach ($tag_counts as $tag => $count) {
            $ntag = htmlspecialchars($tag);
            $ntag = str_replace('"', '&#34;', $ntag);
            $ntag = str_replace('$', '&#36;', $ntag);
            $ntag = str_replace("'", '&#39;', $ntag);

            if (substr($ntag, 0, 1) != '-') //-から始まっているタグはタグクラウド化しない
            {
                if ($cnt < 10) {
                    //表示用のタグクラウドは10件まで出力
                    $tagcloud_links = $tagcloud_links . '<li class="p-tag"><a href="' . $base_url . '/search?q=' . urlencode('#' . $ntag) . '">#' . $ntag . '</a></li>';
                    $tagcloud_nolink_sys = $tagcloud_nolink_sys .   '<li class="p-tag">#' . $ntag . '</li>';
                    $tagcloud_nolink = $tagcloud_nolink . '<li class="p-tag">#' . $ntag . '</li>';
                } else {
                    //非表示用タグクラウド
                    $tagcloud_links_more = $tagcloud_links_more . '<li class="p-tag"><a href="' . $base_url . '/search?q=' . urlencode('#' . $ntag) . '">#' . $ntag . '</a></li>';
                    $tagcloud_nolink_more_sys = $tagcloud_nolink_more_sys .  '<li class="p-tag">#' . $ntag . '</li>';
                    $tagcloud_nolink_more = $tagcloud_nolink_more . '<li class="p-tag">#' . $ntag . '</li>';
                }
                $tagcloud_list = $tagcloud_list . '\'' . $ntag . '\',';
                $cnt++;
            } else {
                // システム用タグクラウドには-タグも記録する
                if ($cnt < 10) {
                    //表示用のタグクラウドは10件まで出力
                    $tagcloud_nolink_sys = $tagcloud_nolink_sys .  '<li class="p-tag">#' . $ntag . '</li>';
                } else {
                    //非表示用タグクラウド
                    $tagcloud_nolink_more_sys = $tagcloud_nolink_more_sys .  '<li class="p-tag">#' . $ntag . '</li>';
                }
            }
            $idx++;
        }
        $more_link = '';
        if ($idx > 10) {
            $more_link = '<li class="p-tag_cloud_more_link" style="cursor:pointer;"> ▼</li>';
        }
        $tagcloud_links = $tagcloud_links . $more_link .  '</ul>';
        $tagcloud_links_more = $tagcloud_links_more .  '</ul>';
        $tagcloud_nolink_sys = $tagcloud_nolink_sys . $more_link .  '</ul>';
        $tagcloud_nolink_more_sys = $tagcloud_nolink_more_sys .  '</ul>';
        $tagcloud_nolink = $tagcloud_nolink . $more_link .  '</ul>';
        $tagcloud_nolink_more = $tagcloud_nolink_more .  '</ul>';
        $tagcloud_list = '[' . $tagcloud_list . ']';

        $fp = fopen('./env/tagcloud.php', 'w');
        fwrite($fp, "<?php\n");
        fwrite($fp, '$tagcloud_links = "' . preg_replace('/[\'"$]/', '\\\\$0', $tagcloud_links)  . '";' . "\n");
        fwrite($fp, '$tagcloud_links_more = "' . preg_replace('/[\'"$]/', '\\\\$0', $tagcloud_links_more)  . '";' . "\n");
        fwrite($fp, '$tagcloud_nolink_sys = "' . preg_replace('/[\'"$]/', '\\\\$0', $tagcloud_nolink_sys)  . '";' . "\n");
        fwrite($fp, '$tagcloud_nolink_more_sys = "' . preg_replace('/[\'"$]/', '\\\\$0', $tagcloud_nolink_more_sys)  . '";' . "\n");
        fwrite($fp, '$tagcloud_nolink = "' . preg_replace('/[\'"$]/', '\\\\$0', $tagcloud_nolink)  . '";' . "\n");
        fwrite($fp, '$tagcloud_nolink_more = "' . preg_replace('/[\'"$]/', '\\\\$0', $tagcloud_nolink_more)  . '";' . "\n");
        fwrite($fp, '$tagcloud_list = ' . $tagcloud_list . ';');
        fclose($fp);
    }

    function Save() {}
}
