<?php

namespace pictpostpersonal\model;

use PDO;
use pictpostpersonal\SQL;
use pictpostpersonal\SQLiteCRUD;

class Setting
{
    private PDO $db;
    private SQLiteCRUD $sqlcrud;
    public $fields;
    public $field_info;
    public $accounts;

    function __construct($db)
    {
        $this->db = $db;
        $this->sqlcrud = new SQLiteCRUD($db);

        //key, default_value, type("1":BOOL)
        $this->field_info = [
            //システム挙動設定
            ['use_rewrite', '0', '1'],                  //1,mod_rewrite利用,利用する,
            ['always_on_ssl', '0', '1'],                //1,常時SSL,利用する,httpでアクセスされた際に、httpsにリダイレクトします
            ['log_level', '50', '0'],                   //0,システムログレベル,,
            ['timezone', 'asia/tokyo', '0'],            //0,タイムゾーン,,
            ['always_nsfw_check', '0', '0'],            //1,NSFW常時チェック,,

            //ゲストモード設定
            ['use_guestwrite', '0', '1'],               //1,ゲストモード,利用する,
            ['guest_attention', '', '0'],               //2,ゲスト記事投稿画面 案内内容,,

            //フィードバック
            ['use_feedback', '1', '1'],                 //1,フィードバック機能,利用する,いいね・表示数カウンタ機能を有効化します
            ['show_likes', '0', '1'],                   //1,いいね数表示,記事にいいね数を表示する,,
            ['show_views', '0', '1'],                   //1,閲覧数表示,記事にいいね数を表示する,,
            ['show_share_button', '0', '1'],            //1,シェアボタン表示,記事にいいね数を表示する,,

            //サイト設定
            ['display_name', 'ユーザー名', '0'],         //0,サイト作者名,,
            ['mail_address', '', '0'],                  //0,連絡用メールアドレス,,メールフォーム等からの連絡先メールアドレス

            ['site_title', '新しいサイト', '0'],         //0,サイトタイトル,,

            ['image_color', '#ffffff', '0'],          //3,サイトのイメージカラー,,
            ['keywords', '', '0'],                      //1,Metaヘッダーのキーワード,,
            ['no_robots', '', '1'],                     //0,ロボット検索除外,除外設定する,
            ['og_text', '', '0'],                       //0,サイト説明文,,SEO用の短い説明文

            ['use_ogimage', '0', '1'],                  //1,サイトイメージ画像,使用する,
            ['use_favicon', '0', '1'],                  //1,favicon,使用する,
            ['ogimage', '0', '0'],                      //0,サイトイメージ画像ファイル,
            ['show_title', '0', '1'],                   //1,タイトル表示,文字で表示する,,
            ['favicon', '0', '0'],                      //0,faviconファイル,
            ['use_nsfw', '0', '1'],                     //1,NSFWサイト指定,NSFW指定する,初回来訪時にNSFW確認ページが表示されます
            ['use_aloways_nsfw', '0', '1'],             //1,NSFW常時警告有無,常時警告する,2回目以降の来訪時にもNSFW確認ページが表示されます

            //シェア
            ['sns_share_use_clipboard', '0', '1'],      //1,シェア時の動作,クリップボードに画像をコピーする,SNSシェア時に画像をクリップボードにコピーします
            ['tweet_service', '', '0'],                 //0,X連携用サービスURL,
            ['tweet_service_key', '', '0'],             //0,X連携用API Key,

            //テーマ
            ['theme', '', '0'],                         //0,テーマ名,,
            ['theme_use_code', '0', '1'],               //0,テーマでのコード使用許可

            //インデックスページ
            ['exclude_index_list_tag', '', '0'],        //0,対象外タグ,,インデックスページの記事一覧の対象外とするタグ
            ['index_articles', '28', '0'],              //0,表示件数,,インデックスページの記事一覧の表示件数
            ['instruction_text', '', '0'],              //0,案内文,,インデックスページの案内文
            ['use_banner', '0', '1'],                   //1,タイトルバナー,使用する,
            ['use_mini_banner', '0', '1'],              //1,リンク用バナー,使用する,
            ['use_icon', '0', '1'],                     //1,作者アイコン,使用する,
            ['banner', '0', '0'],                       //0,タイトルバナー,,
            ['mini_banner', '0', '0'],                  //0,リンク用バナー,,
            ['icon', '0', '0'],                         //0,作者アイコン,,
            ['use_tag_cloud', '1', '1'],                //1,タグクラウド表示,使用する,インデックスページのタグクラウド表示有無

            //エントリーページ
            ['use_entry', '0', '1'],                    //1,エントリーページ,使用する,
            ['entry_password', '', '0'],                //0,入場パスワード,,
            ['entry_text', '', '0'],                    //0,入場ページ用案内文,,

            //記事表示挙動
            ['contents_header', '', '0'],               //0,コンテンツヘッダー,,記事先頭に常時挿入される内容
            ['contents_footer', '', '0'],               //0,コンテンツフッター,,記事末尾に常時挿入される内容
            ['insert_header', '', '0'],                 //0,ヘッダー,,&lthead&gtの前に挿入される内容(全ページ共通)
            ['insert_body_header', '', '0'],            //0,ボディヘッダー,,&ltbody&gt直後に挿入される内容(全ページ共通)
            ['insert_body_footer', '', '0'],            //0,ボディフッター,,&lt/body&gt直前に挿入される内容(全ページ共通)
            ['move_link_title', '0', '0'],              //0,記事移動ラベル,,記事の前後移動リンクラベルのタイプ
            ['move_link_type', '0', '0'],               //0,前後移動の条件,,
            ['use_lightbox', '0', '1'],                 //1,lightbox使用,使用する,

            //記事作成時設定
            ['default_style', '0', '0'],                //0,デフォルトスタイル,,
            ['contents_template', '', '0'],             //0,デフォルト入力内容,,
            ['title_template', '', '0'],                //0,デフォルトタイトル,,

            ['resize_border', '1980', '0'],             //0,リサイズボーダー,,記事投稿時、長辺がこの値を超えるとリサイズされます
            ['thumb_width', '300', '0'],                //0,サムネイル幅,,( 0 = 自動 )
            ['thumb_height', '0', '0'],                 //0,サムネイル高さ,,( 0 = 自動 )
            ['thumb_l_width', '900', '0'],              //0,大サムネイル幅 ,,( 0 = 自動 )
            ['thumb_l_height', '0', '0'],               //0,大サムネイル高さ,,( 0 = 自動 )
            ['write_exif', '0', '1'],                   //1,EXIF記録,,EXIF情報をコメントに自動取り込みするか
            ['index_all_images', '0', '1'],             //1,サムネイルにすべての画像を表示する,,

            ['use_markdown', '0', '1'],                 //1,マークダウン利用,利用する,記事でのフル機能markdown使用有無
            ['use_mini_markdown', '1', '1'],            //1,miniマークダウン利用,利用する,記事でのmini_markdown使用有無
            ['use_rnd_filename', '0', '1'],             //1,画像のランダムファイル名,利用する,画像のファイル名をランダムに生成します

            //ポータル設定
            ['use_portal_feed', '0', '1'],              //1,ポータル連携有無,利用する,ポータル連携有無
            ['portal_feed_urls', '', '0'],              //0,ポータル連携用URL,,
            ['portal_post_tags', '', '0'],              //0,ポータル連携対象のタグ,,
            ['exclude_portal_post_tags', '', '0'],      //0,ポータルサイトへの連動対象外とするタグ,,
            ['portal_tags', '', '0'],                   //0,ポータルへ登録するサイトタグ,,

        ];
        $this->load();
    }

    public static function initialize(SQLiteCRUD $sql_crud)
    {
        $sql_crud->table('settings')->createTable(
            [
                SQL::Id('id'),
                SQL::Text('key'),
                SQL::Text('value')
            ]
        );
    }

    public function initialize_values()
    {
        $this->fields = [];
        foreach ($this->field_info as [$field_name, $default_value, $type]) {
            $this->fields[$field_name] = $default_value;
        }
    }

    function save(bool $use_transaction = true)
    {

        $setting = $this->fields;
        if ($use_transaction) {
            $this->db->beginTransaction();
        }
        foreach ($setting as $key => $value) {
            $this->SaveKeyValue($key, $value);
        }
        if ($use_transaction) {
            $this->db->commit();
        }
    }

    public function load(): array
    {
        $this->initialize_values(); //いったん初期値をセット

        $result = $this->sqlcrud->rawQuery('select * from settings');
        foreach ($result as $item) {
            // 配列の "key" をキーとして、"Value" を値として新しい配列に追加する
            $this->fields[$item['key']] = $item['value'];
        }
        return $this->fields;
    }

    private function saveKeyValue($key, $value)
    {

        $data = [
            'key' => $key,
            'value' => $value
        ];

        if ($this->sqlcrud->table('settings')->where('[key] = :key',  ['key' => $key])->update($data) == 0) {
            $this->sqlcrud->table('settings')->create($data);
        }
    }

    function getValue($key, $default_value)
    {
        if ($this->fields == null) {
            return $default_value;
        }
        if (array_key_exists($key, $this->fields)) {
            return $this->fields[$key];
        } else {
            return $default_value;
        }
    }

    public function setValue($key, $value)
    {
        $this->fields[$key] = $value;
    }
}
