<?php

namespace pictpostpersonal\controller\page;

use pictpostpersonal\controller\ControllerBase;
use pictpostpersonal\controller\api\NavigateApi;
use pictpostpersonal\renderer\ArticleRenderer;
use pictpostpersonal\model\Article;
use pictpostpersonal\model\Account;
use pictpostpersonal\NoSixTemplate2;
use pictpostpersonal\Environment;
use pictpostpersonal\Result;
use pictpostpersonal\Request;
use pictpostpersonal\service\ThemeService;
use pictpostpersonal\Utility;

class MediaPage extends ControllerBase
{

    /**
     * /theme/file_path のリクエストについて、指定されたテーマに基づき
     * /env/themes/file_path のファイルを返す
     *
     * @param request $req
     * 
     * @return Result|null
     * 
     */
    public function getFile(Request $req): ?Result
    {
        $article_id = $req->getArgs('id');
        $sort = $req->getArgs('sort');
        if ($article_id === null || $sort === null) {
            //ID・Sort指定なし
            return new Result(400);
        }

        $article = new Article($this->db, $this->setting);
        $article_data = $article->getById($article_id);
        if ($article_data === null) {
            //指定IDの記事無し
            return new Result(404);
        }

        if (!isset($article_data['media']) || $article_data['media_count'] < $sort) {
            //指定ソート番号の画像なし
            return new Result(404);
        }

        $media = $article_data['media'][$sort - 1];
        $base_dir = realpath('./images/');
        $file_path = realpath("./images/{$media['sub_dir']}{$media['file_name']}");
        if ($file_path === false || strpos($file_path, $base_dir) !== 0) {
            return new Result(403);
        }
        if (!file_exists($file_path)) {
            return new Result(404);
        }

        //ファイル実体を返す
        if (str_ends_with('.css', $file_path)) {
            $mime_type = 'text/css';
        } else {
            $mime_type = mime_content_type($file_path);
        }
        header("Content-Type: $mime_type");
        readfile($file_path);

        return null;
    }
}
