<?php

namespace pictpostpersonal\controller\page;

use pictpostpersonal\controller\ControllerBase;

use Exception;
use pictpostpersonal\Authentification;
use pictpostpersonal\Environment;
use pictpostpersonal\PPPDateTime;
use pictpostpersonal\Request;
use pictpostpersonal\Result;
use pictpostpersonal\SQLiteCRUD;
use pictpostpersonal\model\Activity;
use pictpostpersonal\model\Article;
use pictpostpersonal\model\Message;
use pictpostpersonal\NoSixTemplate2;
use pictpostpersonal\Utility;

class ConsolePage2 extends ControllerBase
{

    public function showConsole(Request $req): ?Result
    {

        $article_model = new Article($this->db, $this->setting);

        //下書き一覧
        ['articles' => $drafts, 'count' => $drafts_count]  = $article_model->searchWithTotalCount('status = 1 and [type] = 0', [], ['created_at DESC'], 10, 0);
        //データ整形
        foreach ($drafts as $key => $item) {
            $caption = Utility::createCaption($item['contents']);
            $drafts[$key]['caption'] = s($caption);
            $drafts[$key]['title'] = h($item['title']);
            $drafts[$key]['created_at'] = s($item['created_at']);
            $thumbnail = Utility::getThumbnailUrl($item, true);
            $drafts[$key]['thumbnail'] = $thumbnail;
        }
        $message = '';
        if ($drafts_count == 0) {
            $message = 'まだ記事は投稿されていません';
        }

        //記事一覧
        ['articles' => $articles, 'count' => $articles_count]  = $article_model->searchWithTotalCount('status <> 1 and [type] = 0', [], ['created_at DESC'], 10, 0);
        //データ整形
        foreach ($articles as $key => $item) {
            $caption = Utility::createCaption($item['contents']);
            $articles[$key]['caption'] = s($caption);
            $articles[$key]['title'] = h($item['title']);
            $articles[$key]['created_at'] = s($item['created_at']);
            $thumbnail = Utility::getThumbnailUrl($item, true);
            $articles[$key]['thumbnail'] = $thumbnail;
        }
        $message = '';
        if ($drafts_count == 0) {
            $message = 'まだ記事は投稿されていません';
        }

        $activity_model = new Activity($this->db);

        //Like数
        $today_likes = $activity_model->getDayLikeCount();
        $lastweek_likes = $activity_model->getWeekLikeCount();

        $dt = new \DateTime('now', new \DateTimeZone('UTC'));
        $dt->modify('-7 days');
        $lastweek_likes_span = PPPDateTime::getDateTime($dt, 'y-m-d') . ' ～ ' . PPPDateTime::getCurrentDateTime('y-m-d');

        //未読メッセージ数
        $message_model = new Message($this->db, $this->setting);
        $unread_message_count = $message_model->getUnreadCommentCount();

        //UIレンダリング
        $template = new NoSixTemplate2('template2_console.php', ['./core/templates_sys'], './env/template_cache');
        self::setSiteData($template); //サイト関連情報を設定
        self::setSystemArea($template); //管理系情報を設定

        //ページ関連情報を設定
        $template->set_data('page_description', '');
        $template->set_data('page_keywords', '');
        $template->set_data('page_author', $this->setting->GetValue('display_name', ''));
        $template->set_data('page_title', '管理画面 - ' . $this->setting->GetValue('site_title', '新しいサイト'));

        //コンテンツデータを設定
        $template->set_data('drafts', $drafts);
        $template->set_data('articles', $articles);
        $template->set_data('today_likes', $today_likes);
        $template->set_data('week_likes', $lastweek_likes);
        $template->set_data('week_likes_span', $lastweek_likes_span);
        $template->set_data('messages', $unread_message_count);

        $output = $template->getString();

        $result = new result();
        $result->output = $output;
        return $result;
    }
}
