<?php

namespace pictpostpersonal\controller\page;

use pictpostpersonal\renderer\ArticleRenderer;
use pictpostpersonal\controller\ControllerBase;
use pictpostpersonal\Request;
use pictpostpersonal\Result;
use pictpostpersonal\model\Activity;
use pictpostpersonal\model\Article;
use pictpostpersonal\Utility;
/*
メモ

・Sessionの使用が必要なパターン
　　・alway_nsfw かつ pagebreak または article_listあり
　　・password かつ pagebreak または article_listあり

*/

class ArticlePage extends ControllerBase
{
    private function recordNSFWConsent(Request $req)
    {
        //NSFW回答データがパラメータとして渡されていればCookieに記録
        $nsfw = $req->getArgs('nsfw', null);
        if ($nsfw === 'true') {
            Utility::SetCookie('nsfw_consent', $nsfw, Utility::calcExpires(15, 0, 0, 0), false);
        }
    }

    function countUp($id)
    {
        if ($this->setting->getValue('use_feedback', '1')) {
            $model = new Activity($this->db);
            $model->addViewCount($id);
        }
    }

    function showArticleByDate($req): Result
    {
        $year = $req->getArgs('year', '0');
        $month = $req->getArgs('month', '0');
        $day = $req->getArgs('day', '0');
        $index = $req->getArgs('index', '1');
        $datetime = "$year-$month-$day";

        if (!Utility::isValidDate($datetime)) {
            $result = new result();
            $result->status = 404;
            return $result;
        }

        $model = new Article($this->db, $this->setting);
        $articles = $model->search("created_at >= '{$datetime} 00:00:00' and created_at <= '{$datetime} 23:59:59'", [], ['created_at asc']);
        if (count($articles) == 0) {
            $result = new result();
            $result->status = 404;
            return $result;
        }
        $show_indexes = explode(',', $req->getArgs('page', '1'));
        $article_service = new ArticleRenderer($this->context);
        $article_service->setUrl($articles[0]);
        return $article_service->show($req, $articles[0], $show_indexes);
    }

    function showArticleByQ($req): Result
    {
        $article_service = new ArticleRenderer($this->context);
        try {
            $show_indexes = explode(',', $req->getArgs('page', '1'));
            $article_id_or_url = $req->getArgs('q', -1);
        } catch (\Exception $ex) {
            return new Result(400);
        }
        $this->recordNSFWConsent($req);

        //ID指定がない場合はエラーとする
        if ($article_id_or_url == null || $article_id_or_url == -1) {
            $result = new result();
            $result->status = 404;
            return $result;
        }

        //IDから記事情報を取得する
        $model = new Article($this->db, $this->setting);
        if (is_numeric($article_id_or_url)) {
            //数字の場合IDとして判断
            $article_data = $model->GetById($article_id_or_url);
            if ($article_data == null) {
                $article_data = $model->GetByAltURL($article_id_or_url);
            }
        } else {
            //文字列の場合固定URLとして判断
            $article_data = $model->GetByAltURL($article_id_or_url);
        }

        if ($article_data == null || $article_data['type'] >= 2) {
            $result = new result();
            $result->status = 404;
            return $result;
        } else if ($article_data['status'] != 0 && $this->auth->isLogin() == false) {
            //非公開設定 かつ ログインしていない場合も404扱いとする
            $result = new result();
            $result->status = 404;
            return $result;
        }

        $this->countUp($article_data['id']);
        $article_service->setUrl($article_data);
        return $article_service->show($req, $article_data, $show_indexes);
    }

    function showArticleById($req): Result
    {
        $article_service = new ArticleRenderer($this->context);
        try {
            $show_indexes = explode(',', $req->getArgs('page', '1'));
            $article_id = $req->getArgs('id', -1);
        } catch (\Exception $ex) {
            return new Result(400);
        }

        $this->recordNSFWConsent($req);;

        //ID指定がない場合はエラーとする
        if ($article_id == null || $article_id == -1) {
            $result = new result();
            $result->status = 404;
            return $result;
        }

        //IDから記事情報を取得する
        $model = new Article($this->db, $this->setting);
        $article_data = $model->GetById($article_id);
        if ($article_data == null || $article_data['type'] >= 2) {
            $result = new result();
            $result->status = 404;
            return $result;
        } else if ($article_data['status'] != 0 && $this->auth->isLogin() == false) {
            //非公開設定 かつ ログインしていない場合も404扱いとする
            $result = new result();
            $result->status = 404;
            return $result;
        }
        $this->countUp($article_data['id']);
        $article_service->setUrl($article_data);
        return $article_service->show($req, $article_data,  $show_indexes);
    }

    function showArticleByURL($req)
    {
        $article_service = new ArticleRenderer($this->context);
        try {
            $show_indexes = explode(',', $req->getArgs('page', '1'));
        } catch (\Exception $ex) {
            return new Result(400);
        }
        $url = $req->url;
        $this->recordNSFWConsent($req);

        $model = new Article($this->db, $this->setting);
        $article_data = $model->GetByAltURL($url);
        if ($article_data == null || $article_data['type'] >= 2) {
            $result = new result();
            $result->status = 404;
            return $result;
        } else if ($article_data['status'] != 0 && $this->auth->isLogin() == false) {
            //非公開設定 かつ ログインしていない場合も404扱いとする
            $result = new result();
            $result->status = 404;
            return $result;
        }
        $this->countUp($article_data['id']);
        $article_service->setUrl($article_data);
        return $article_service->show($req, $article_data, $show_indexes);
    }
}
