<?php

namespace pictpostpersonal\controller\page;

use pictpostpersonal\controller\ControllerBase;

use pictpostpersonal\Request;
use pictpostpersonal\Result;
use pictpostpersonal\NoSixTemplate2;

use const pictpostpersonal\USER_CSS_PATH;

class AdminTool extends ControllerBase
{
    public function show(Request $req): ?Result
    {
        //UIレンダリング
        $template = new NoSixTemplate2('template2_console_admintool.php', ['./core/templates_sys'], './env/template_cache');
        self::setSiteData($template); //サイト関連情報を設定
        self::setSystemArea($template); //管理系情報を設定
        $output = $template->getString();
        $result = new result();
        $result->output = $output;
        return $result;
    }

    /**
     * UserCSSを保存する
     *
     * @param Request $req
     * 
     * @return Result|null
     * 
     */
    public function saveUserCss(Request $req): ?Result
    {
        $args = $req->args_raw;
        if (($args['encode'] ?? '') == 'base64') {
            $args['css'] = base64_decode($args['css']); //WAF対策
        }

        file_put_contents(USER_CSS_PATH, $args['css']);

        return new Result(200, "{\"status\":\"succedss\", \"message\":\"成功しました\"}");
    }

    /**
     * UserCSS編集画面を表示する
     *
     * @param Request $req
     * 
     * @return Result|null
     * 
     */
    public function showUserCss(Request $req): ?Result
    {
        if (file_exists(USER_CSS_PATH)) {
            $css = file_get_contents(USER_CSS_PATH);
        } else {
            $css = '';
        }
        //UIレンダリング
        $template = new NoSixTemplate2('template2_console_css.php', ['./core/templates_sys'], './env/template_cache');
        self::setSiteData($template); //サイト関連情報を設定
        self::setSystemArea($template); //管理系情報を設定

        //ページ関連情報を設定
        $template->set_data('page_description', '');
        $template->set_data('page_keywords', '');
        $template->set_data('page_author', $this->setting->GetValue('display_name', ''));
        $template->set_data('page_title', 'CSS編集 - ' . $this->setting->GetValue('site_title', '新しいサイト'));

        //コンテンツデータを設定
        $template->set_data('css', $css);
        $output = $template->getString();
        $result = new result();
        $result->output = $output;
        return $result;
    }

    //設定等のバックアップアーカイブを作成してダウンロードする
    function backupSettings()
    {
        $zip = new \ZipArchive();
        $zip_file_name = './{$system_db_file}.zip';
        $dir_path = dirname(__FILE__) . '/env';

        if ($zip->open($zip_file_name, \ZipArchive::CREATE) === true) {
            // 空のフォルダを追加
            $zip->addEmptyDir('ppp_backup');

            // フォルダ内のファイルを追加
            $files = new \RecursiveIteratorIterator(
                new \RecursiveDirectoryIterator($dir_path),
                \RecursiveIteratorIterator::LEAVES_ONLY
            );
            foreach ($files as $name => $file) {
                if (!$file->isDir()) {
                    $file_path = $file->getRealPath();
                    $relative_path = substr($file_path, strlen($dir_path) + 1);
                    $zip->addFile($file_path, 'ppp_backup/' . $relative_path);
                }
            }
            $zip->close();

            // ファイルをダウンロード
            $date = new \DateTime('now', new \DateTimeZone($this->setting->getValue('timezone', 'Asia/Tokyo')));
            $yyyymmdd = $date->format('Ymd');

            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename="ppp_backup_' . $yyyymmdd . '.zip"');
            readfile($zip_file_name);

            // ダウンロード後、ファイルを削除
            unlink($zip_file_name);
        } else {
            echo 'アーカイブの作成に失敗しました。';
        }
    }

    //CSV出力
    function csvExport($db, $table_name = 'articles')
    {
        $output_csv_file = './env/' . bin2hex(random_bytes(rand(15, 20))) . '.csv';
        $file = fopen($output_csv_file, 'w');

        $query = "PRAGMA table_info($table_name)";
        $result = $db->query($query);
        $headers = [];
        while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
            $headers[] = $row['name'];
        }
        fputcsv($file, $headers);

        $query = "SELECT * FROM $table_name";
        $result = $db->query($query);
        while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
            fputcsv($file, $row);
        }

        fclose($file);

        // ファイルをダウンロード
        $date = new \DateTime('now', new \DateTimeZone($this->setting->getValue('timezone', 'Asia/Tokyo')));
        $yyyymmdd = $date->format('Ymd');
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="ppp_export_' . $table_name . '_' . $yyyymmdd . '.csv"');
        readfile($output_csv_file);

        // ダウンロード後、ファイルを削除
        unlink($output_csv_file);
    }
}
