<?php

namespace pictpostpersonal\controller\middleware;

use pictpostpersonal\controller\ControllerBase;

use pictpostpersonal\Utility;
use pictpostpersonal\Result;
use pictpostpersonal\Request;
use pictpostpersonal\FlashMessage;
use pictpostpersonal\service\ThemeService;
use pictpostpersonal\renderer\ArticleRenderer;
use pictpostpersonal\model\Article;

/**
 * 
 * サイト全体NSFW指定時の同意確認用ミドルウェア
 * 
 */
class NSFWMiddleware extends ControllerBase
{
    public function siteNSFWCheck($req)
    {
        if ($req->getArgs('nsfw', '') === 'true') {
            FlashMessage::clearMessage('nsfw');
            Utility::SetCookie('nsfw_consent', 'true', Utility::calcExpires(30, 0, 0, 0), false);
        } else if ($this->setting->getValue('use_nsfw', false)) {
            //サイトNSFWが有効の場合
            if (!$req->getCookie('nsfw_consent', false)) {
                //同意なし⇒NSFW同意ページへリダイレクト
                FlashMessage::clearMessage('nsfw');
                FlashMessage::setMessage(
                    'nsfw',
                    [
                        'title' => $this->setting->getValue('site_title', ''),
                        'type' => 0,
                        'url' => $req->request,
                        'return_url' => ''
                    ]
                );
                $result = new Result();
                $result->redirect_action = 'middleware\NSFWMiddleware:show';
                return $result;
            }
        }
        return null;
    }

    function show(Request $req)
    {
        $flash = FlashMessage::getMessage('nsfw', ['title' => $this->setting->getValue('site_title', ''), 'type' => 0, 'url' => '/', 'return_url' => '']);
        $title = $flash['title'];
        $type = $flash['type'];
        $redirect_url =  $flash['url'];
        $return_url = $flash['return_url'];

        if (strpos($redirect_url, '?') !== false) {
            $redirect_url .= '&nsfw=true';
        } else {
            $redirect_url .= '?nsfw=true';
        }

        $article_cls = new Article($this->db, $this->setting);
        $article_data = $article_cls->getNSFWPage(true);

        $data = [
            'current' => &$article_data,
            'next' => [],
            'prev' => [],
            'next_link' => "",
            'prev_link' => "",
            'manga_mode' => false,
            'nsfw_ans' => false
        ];

        $article_service = new ArticleRenderer($this->context);
        $article_service->setUrl($article_data);
        $contents = $article_service->createContents($data, $article_data['contents'], true, [0]);
        $home_menu = $article_service->createHomeMenu($article_cls);

        $template = ThemeService::getThemeTemplate('template2_nsfw.php', $this->db, $this->setting);

        self::setSiteData($template); //サイト関連情報を設定
        self::setSystemArea($template); //管理系情報を設定
        //ページ関連情報を設定
        $template->set_data('page_description', strip_tags($caption ?? ''));
        $template->set_data('page_keywords', '');
        $template->set_data('page_author', $this->setting->GetValue('display_name', ''));
        $template->set_data('page_title', "{$title} - {$this->setting->GetValue('site_title', '新しいサイト')}");
        $template->set_data('page_url', $redirect_url);

        $template->set_data('contents', $contents);
        $template->set_data('home_menu', $home_menu);

        $template->set_data('type', $type);
        $template->set_data('redirect_url', $redirect_url);
        $template->set_data('return_url', $return_url);
        $template->set_data('title', $title);
        $template->set_data('cancel_title', $type == 0 ? '退出' : '戻る');

        $result = new Result(200, $template->getString());
        $result->next = false; //ここで出力停止する
        return $result;
    }

    function consent(Request $req)
    {
        $consent = $req->getArgs('consent', false);
        $redirect_url = $req->getArgs('redirect_url', '/');
        $return_url = $req->getArgs('return_url', 'https://www.google.com');
        if ($consent) {
            //同意状態でリダイレクト
            $req->getCookie('nsfw_consent', true);

            if (
                strpos($redirect_url, '?') !== false
            ) {
                $redirect_url .= '&nsfw=true';
            } else {
                $redirect_url .= '?nsfw=true';
            }

            $result = new Result();
            $result->redirect = $redirect_url;
            return $result;
        } else {
            $result = new Result();
            $result->redirect = $return_url;
            return $result;
        }
    }
}
