<?php

namespace pictpostpersonal\controller\middleware;

use pictpostpersonal\controller\ControllerBase;

use pictpostpersonal\Utility;
use pictpostpersonal\Result;
use pictpostpersonal\Request;
use pictpostpersonal\service\ThemeService;
use pictpostpersonal\model\Article;
use pictpostpersonal\renderer\ArticleRenderer;
use pictpostpersonal\FlashMessage;

/**
 * 
 * サイトエントリー画面 承認確認ミドルウェア
 * 
 */
class EntryMiddleware extends ControllerBase
{
    public function siteEntryCheck($req)
    {
        if ($req->getArgs('entry', '') === 'true') {
            FlashMessage::clearMessage('entry');
            Utility::SetCookie('entry_consent', 'true', Utility::calcExpires(30, 0, 0, 0), false);
        } else if ($this->setting->getValue('use_entry', false)) {
            //サイトentryが有効の場合
            if (!$req->getCookie('entry_consent', false)) {
                //同意なし⇒entry同意ページへリダイレクト
                FlashMessage::clearMessage('entry');
                FlashMessage::setMessage(
                    'entry',
                    [
                        'title' => $this->setting->getValue('site_title', ''),
                        'type' => 0,
                        'url' => $req->request,
                        'return_url' => ''
                    ]
                );
                $result = new Result();
                $result->redirect_action = 'middleware\EntryMiddleware:show';
                return $result;
            }
        }
        return null;
    }

    function show(Request $req)
    {
        $flash = FlashMessage::getMessage('entry', ['title' => $this->setting->getValue('site_title', ''), 'type' => 0, 'url' => '/', 'return_url' => '']);
        $title = $flash['title'];
        $type = $flash['type'];
        $redirect_url =  $flash['url'];
        $return_url = $flash['return_url'];

        if (strpos($redirect_url, '?') !== false) {
            $redirect_url .= '&entry=true';
        } else {
            $redirect_url .= '?entry=true';
        }

        $error_password = false;
        if ($req->getArgs('password', '') != '') {
            //パスワードが指定されている場合、パスワード間違いでリダイレクトされあt
            $error_password = true;
        }

        $article_cls = new Article($this->db, $this->setting);
        $article = $article_cls->getEntryPage(true);
        $article_service = new ArticleRenderer($this->context);
        $article_service->setUrl($article);
        $contents = $article_service->createContents($article, $article['contents'], true, [0]);
        $home_menu = $article_service->createHomeMenu($article_cls);

        $template = ThemeService::getThemeTemplate('template2_entry.php', $this->db, $this->setting);
        $title = $this->setting->GetValue('site_title', '新しいサイト');

        self::setSiteData($template); //サイト関連情報を設定
        self::setSystemArea($template); //管理系情報を設定

        //ページ関連情報を設定
        $template->set_data('page_description', $this->setting->GetValue('og_text', ''));
        $template->set_data('page_keywords', $this->setting->GetValue('keywords', ''));
        $template->set_data('page_title', $title);
        $template->set_data('page_url', SITE_URL);

        $template->set_data('home_menu', $home_menu);
        $template->set_data('contents', $contents);

        $template->set_data('type', $type);
        $template->set_data('redirect_url', $redirect_url);
        $template->set_data('return_url', $return_url);
        $template->set_data('password', $this->setting->getValue('entry_password', ''));
        $template->set_data('use_password', $this->setting->getValue('entry_password', '') != '');
        $template->set_data('title', $title);
        $template->set_data('error_password', $error_password);

        $result = new Result(200, $template->getString());
        $result->next = false; //ここで出力停止する
        return $result;
    }

    function consent(Request $req)
    {
        $consent = $req->getArgs('consent', false);

        //パスワード指定がある場合パスワードチェック
        $password = $this->setting->getValue('entry_password', '');
        if ($password != '') {
            if ($req->getArgs('password', '') != $password) {
                //パスワードが異なる
                $result = new Result();
                $result->redirect = $req->url;
                return $result;
            }
        }

        $redirect_url = $req->getArgs('redirect_url', '/');
        $return_url = $req->getArgs('return_url', 'https://www.google.com');
        if ($consent) {
            //同意状態でリダイレクト
            $result = new Result();
            $result->redirect = $redirect_url;
            return $result;
        } else {
            $result = new Result();
            $result->redirect = $return_url;
            return $result;
        }
    }
}
