<?php

namespace pictpostpersonal\controller\middleware;

use pictpostpersonal\controller\ControllerBase;

use pictpostpersonal\Request;
use pictpostpersonal\Result;
use pictpostpersonal\FlashMessage;

/**
 * 認証確認用ミドルウェア
 * 未認証の場合ログインページへの遷移またはエラー応答する
 */
class AuthMiddleware extends ControllerBase
{
    /**
     * ページ用認証確認処理
     * ログインしていない場合はログインページへ遷移する
     *
     * @param Request $req
     * 
     * @return Result|null
     * 
     */
    function adminCheck(Request $req): ?Result
    {
        if (!$this->auth->isLogin()) {
            //ログインしていない場合はリダイレクト
            FlashMessage::setMessage('login', ['message' => 'ログインが必要です', 'url' => $req->request_url]);
            $result = new Result();
            $result->status = 307;
            $result->redirect = BASE_URL . '/login';
            $result->next = false;
            return $result;
        }
        return null;
    }

    /**
     * API用認証確認処理
     * ログインしていない場合は401応答し、エラーJSONを返す
     *
     * @param Request $req
     * 
     * @return Result|null
     * 
     */
    function adminCheckApi(Request $req): ?Result
    {
        if (!$this->auth->isLogin()) {
            //ログインしていない場合はエラー出力
            $result = new Result();
            $result->status = 401;
            $result->next = false;
            $result->output = "{\"status\":\"error\", \"message\":\"ログインしていません\"}";
            return $result;
        }
        return null;
    }
}
