<?php

namespace pictpostpersonal\controller\api;

use pictpostpersonal\controller\ControllerBase;

use Exception;
use pictpostpersonal\Environment;
use pictpostpersonal\Result;
use pictpostpersonal\Request;
use pictpostpersonal\model\Message;

use const pictpostpersonal\ENV_PATH;

/**
 * メッセージ操作にかかわるAPIを提供するクラス
 */
class MailApi extends ControllerBase
{

    private function validate($req)
    {
        $title = htmlspecialchars($req->getArgs('tittle', ''));
        $name = htmlspecialchars($req->getArgs('name', 'unknown'));
        $email = $req->getArgs('email', '');
        $return_message = htmlspecialchars($req->getArgs('return_message', ''));
        $message = trim(htmlspecialchars($req->getArgs('comment', '')));
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $user_agent = htmlspecialchars($_SERVER['HTTP_USER_AGENT']);

        //自動入力排除用
        if ($title != '') {
            die('{"status":"error","message":"送信できません"}');
        }

        //送信元確認用
        $from = $_SERVER['HTTP_REFERER'] ?? '';
        if ($from == '') {
            die('{"status":"error","message":"送信できません"}');
        }

        // メールアドレスの検証
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            die('{"status":"error","message":"無効なメールアドレス"}');
        }

        // 改行文字の除去
        $email = str_replace(["\r", "\n"], '', $email);

        // SPAMチェック
        if (file_exists(ENV_PATH . '/spamfilter.php')) {
            include(ENV_PATH . '/spamfilter.php');
            $result = spamFilter(['name' => $name, 'email' => $email, 'message' => $message, 'ip_address' => $ip_address, 'user_agent' => $user_agent]);
            if ($result == false) {
                die('{"status":"error","message":"送信できません"}');
            }
        }


        return [$name, $email, $message, $return_message, $ip_address, $user_agent];
    }

    private function crawlerResult()
    {
        //クローラー判定
        $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        $is_crawler = preg_match('/bot|crawl|slurp|spider/i', $user_agent);
        if ($is_crawler) {
            //とりあえず成功ということにしとく
            echo '{"status":"success"}';
            exit();
        }
    }
    /**
     * メッセージを作成/更新する
     *
     * @param Request $req
     *
     * @return Result
     *
     */
    function create(Request $req): Result
    {
        if (Environment::isDemoMode()) {
            //デモモードの場合 成功ということにしとく
            echo '{"status":"success"}';
            exit();
        }

        //クローラーであれば処理終了させる
        $this->crawlerResult();

        // メール送信先
        $to = $this->setting->getValue('mail_address', '');
        if ($to == '') {
            die('{"status":"error","message":"メール機能が有効化されていません"}');
        }

        [$name, $email, $message, $return_message, $ip_address, $user_agent] = $this->validate($req);

        if ($message == '') {
            $result = new Result();
            $result->mime_type = 'application/json';
            $result->output = "{\"status\":\"error\", \"message\":\"コメントを入力してください\"}";
            return $result;
        }



        // メールの内容を作成
        $subject = '[PPP Mail] メールフォームからのコメント';
        $body = "名前：$name\n";
        $body .= "コメント：$message\n";
        $body .= "メールアドレス：$email\n";
        $body .= "IPアドレス：$ip_address\n";
        $body .= "ユーザーエージェント：$user_agent\n";

        // 送信元の設定
        $headers = "From: $email\r\n";
        $headers .= "Reply-To: $email\r\n";
        $headers .= "Content-Type: text/plain; charset=utf-8\r\n";

        mb_language('uni');
        mb_internal_encoding('UTF-8');
        // メールの送信
        if (mb_send_mail($to, $subject, $body, $headers)) {
            echo '{"status":"success", "message":"' .  $return_message . '"}';
        } else {
            die('{"status":"error","message":"送信に失敗しました"}');
        }


        try {
            $article = new Message($this->db, $this->setting);
            $id = $article->create(-1, $name, $email, $message);
            $result = new Result();
            $result->mime_type = 'application/json';
            $result->output = "{\"status\":\"success\", \"id\":\"$id\", \"message\":\"$return_message\"}";
            return $result;
        } catch (Exception $ex) {
            $result = new Result();
            $result->mime_type = 'application/json';
            $result->output = "{\"status\":\"error\", \"message\":\"{$ex->getMessage()}\"}";
            return $result;
        }
    }
}
