<?php

namespace pictpostpersonal\controller\api;

use pictpostpersonal\controller\ControllerBase;

use pictpostpersonal\Request;
use pictpostpersonal\Result;
use pictpostpersonal\model\Activity;

/**
 * アクティビティ操作にかかわるAPIを提供するクラス
 */
class ActivityApi extends ControllerBase
{

    /**
     * すべての通知を既読にする
     *
     * @param Request $req
     * 
     * @return Result
     *
     */
    function markAllAsRead(Request $req): Result
    {
        $model = new Activity($this->db);
        $model->markAllAsRead();

        $result = new Result();
        $result->mime_type = 'application/json';
        $result->output =  "{\"status\":\"success\", \"message\":\"OK\"}";
        return $result;
    }


    /**
     * 通知を取得する。
     * 　引数：
     *      unreadonly  未読のみを取得するか。 true, false。
     *      format  返却地のフォーマットを指定する。html,json。
     *
     * @param Request $req
     * 
     * @return Result
     *
     */
    function get(Request $req): Result
    {
        $is_unread_only = $req->getArgs('unreadonly', false, Request::FILTER_BOOLEAN);
        $format = $req->getArgs('format', 'html');
        $model = new Activity($this->db);
        $result = $model->findLatestActivities($is_unread_only);

        $base = BASE_URL;

        if ($format === 'html') {
            $html = '';
            foreach ($result as $row) {
                $title = htmlspecialchars($row['title'] ?? '');
                if ($row['action'] === 'like') {
                    $html = "$html<li><a href='{$base}/log/{$row['id']}'>「{$title}」</a> が <em>{$row['total']}</em>回「いいね！」されました</li>";
                } else if ($row['action'] === 'comment' && $row['target'] != -1) {
                    $html = "$html<li><a href='{$base}/log/{$row['id']}'>「{$title}」</a> に コメントされました</li>";
                } else if ($row['action'] === 'comment' && $row['target'] == -1) {
                    $html = "$html<li><a href='{$base}/console/message'>{$row['created_at']}</a> メッセージが届きました</li>";
                }
            }
            if ($html != '') {
                $html = "<ul class='p-notification-list'>" . $html . "</ul>";
            }
            $result_body = [
                'success' => 'ok',
                'html' => $html
            ];
        } else {
            $result_body = [
                'success' => 'ok',
                'json' => $result
            ];
        }
        $result = new Result();
        $result->mime_type = 'application/json';
        $result->output =  json_encode($result_body);
        return $result;
    }
}
