<?php

namespace pictpostpersonal\controller;

use pictpostpersonal\Authentification;
use pictpostpersonal\CsrfUtility;
use pictpostpersonal\Environment;
use pictpostpersonal\NoSixTemplate2;
use pictpostpersonal\Context;
use pictpostpersonal\Logger;
use pictpostpersonal\model\Setting;
use pictpostpersonal\service\ThemeService;

class ControllerBase
{
    protected \PDO $db;
    protected Setting $setting;
    protected Authentification $auth;
    protected Logger $log;
    protected Context $context;

    public function __construct(Context $context)
    {
        $this->context = $context;
        $this->db = $context->getDb();
        $this->setting = $context->getSetting();
        $this->log = $context->getLog();
        $this->auth = $context->getAuth();
    }

    //各ページ共通のテンプレート変数設定処理
    protected function setSiteData($template)
    {
        $title = $this->setting->getValue('site_title', '新しいサイト');
        $site_url = SITE_URL;
        $template->set_data('site_url', SITE_URL);
        $template->set_data('base_url', BASE_URL);
        $template->set_data('settings', $this->setting->fields);

        $template->set_data('site_description', $this->setting->getValue('og_text', ''));
        $template->set_data('site_keywords', $this->setting->getValue('keywords', ''));
        $template->set_data('site_author', $this->setting->getValue('display_name', ''));
        $template->set_data('site_author_icon', $this->setting->getValue('use_icon', false) !== false ?  "{$site_url}/images/{$this->setting->getValue('icon', '')}" : '');
        $template->set_data('site_title', $title);
        $template->set_data('site_og_image', $this->setting->getValue('use_ogimage', '') !== false ? "{$site_url}/images/{$this->setting->getValue('ogimage', '')}" : '');

        $template->set_data('favicon', $this->setting->getValue('use_favicon', '') !== false ? "{$site_url}/images/{$this->setting->getValue('favicon', '')}" : '');
        $template->set_data('mini_banner', $this->setting->getValue('use_mini_banner', '') !== false ? "{$site_url}/images/{$this->setting->getValue('mini_banner', '')}" : '');

        //トップバナー用HTML生成
        $banner = '';
        $banner_class = '';
        $banner_title_class = '';
        if ($this->setting->getValue('use_banner', false) && $this->setting->getValue('show_title', false)) {
            //バナー指定あり・タイトル表示あり のHTML
            $banner_class = 'p-title-banner-with-bg';
            $banner_title_class = '';
            $banner = "<div class=\"p-title-banner-area\" class=\"{$banner_class}\"><h1 id=\"title\"  class=\"{$banner_title_class}\">$title</h1><img src=\"$site_url/images/{$this->setting->getValue('banner', '')}\" alt=\"タイトルバナー\"></div>";
        } elseif ($this->setting->getValue('use_banner', false)) {
            //バナー指定あり・タイトル表示なし のHTML
            $banner_class = 'title-banner-with-bg';
            $banner_title_class = 'p-hide';
            $banner = "<div class=\"p-title-banner-area\" class=\"{$banner_class}\"><h1 id=\"title\"  class=\"{$banner_title_class}\">$title</h1><img src=\"$site_url/images/{$this->setting->getValue('banner', '')}\" alt=\"タイトルバナー\"></div>";
        } else {
            //バナーなしのHTML
            $banner_class = 'p-title-banner-without-bg';
            $banner_title_class = '';
            $banner = "<div class=\"p-title-banner-area\" class=\"{$banner_class}\"><h1 id=\"title\"  class=\"{$banner_title_class}\">$title</h1></div>";
        }
        $template->set_data('top_banner', "$site_url/images/{$this->setting->getValue('banner', '')}");
        $template->set_data('top_banner_html', $banner);
        $template->set_data('top_banner_class', $banner_class);
        $template->set_data('top_banner_title_class', $banner_title_class);

        $template->set_data('sys_insert_header', $this->setting->getValue('insert_header', '') . "\r\n");
        $template->set_data('sys_insert_body_header', $this->setting->getValue('insert_body_header', '') . "\r\n");
        $template->set_data('sys_insert_body_footer', $this->setting->getValue('insert_body_footer', '') . "\r\n");
    }

    protected function setSystemArea($template, $sys_message = "", $data = [])
    {
        $version = Environment::getVersion();

        $powered = "powered by <a href=\"https://ppp.kannagi.net/\" target=\"_blank\">PictPostPersonal SBS Ver.{$version}</a>";
        $template->set_data('powered_info', $powered);

        if (!$this->auth->isLogin()) {
            $template->set_data('admin_header', '');
        } else {

            //CSRF対策トークン埋め込み
            $template->set_data('csrf', CsrfUtility::createCSRFTokenHtml());

            $sys_template = new NoSixTemplate2('template2_admin_header.php', ['./env/templates', './themes/' . $this->setting->getValue('theme', ''), './core/templates', './core/templates_sys'], './env/template_cache');
            $sys_template->set_data('site_url', SITE_URL);
            $sys_template->set_data('base_url', BASE_URL);
            $sys_template->set_data('sys_message', $sys_message);
            $sys_template->set_data('page_data', $data);
            $sys_template->set_data('settings', $this->setting->fields);
            $html = $sys_template->getString();

            $template->set_data('admin_header', $html);
        }
    }
}
