<?php

namespace pictpostpersonal;

use Exception;
use PDO;
use PDOException;

/**
 * SQLiteCRUDによるテーブル操作用補助クラス
 */
class SQL
{
    static public function Id(string $field_name): string
    {
        return "$field_name INTEGER PRIMARY KEY AUTOINCREMENT";
    }

    static public function Text(string $field_name, string $default = null, string $option = ''): string
    {
        $default_format = '';
        if ($default !== null) {
            $default_format = "DEFAULT '$default'";
        }
        return "$field_name TEXT $default_format $option";
    }
    static public function Bool(string $field_name, bool $default = null, string $option = ''): string
    {
        $default_format = '';
        if ($default !== null) {
            if ($default === true) {
                $default_format = 'DEFAULT \'1\'';
            } else {
                $default_format = 'DEFAULT \'0\'';
            }
        }
        return "$field_name BOOL $default_format $option";
    }

    static public function DateTime(string $field_name, string $option = '')
    {
        return "$field_name DATETIME $option";
    }

    static public function Integer(string $field_name, string $default = null, string $option = '')
    {
        $default_format = '';
        if ($default !== null) {
            $default_format = "DEFAULT '$default'";
        }
        return "$field_name Integer $default_format $option";
    }
}
