<?php

namespace pictpostpersonal;

class ResponseEmitter implements ResponseEmitterInterface
{
    public function setStatus($code): void
    {
        http_response_code($code);
    }

    public function setHeader(string $header): void
    {
        header($header);
    }

    public function output(string $data): void
    {
        if (!headers_sent()) {
            header('Content-Type: text/html; charset=UTF-8');
        }
        header('X-Content-Type-Options: nosniff');
        header('X-Frame-Options: SAMEORIGIN');
        header('X-XSS-Protection: 1; mode=block');
        echo $data;
    }

    public function outputFile(string $file_path, string $mime_type): void
    {
        if (file_exists($file_path)) {
            header('Content-Type: ' . $mime_type);
            //header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
            header('Content-Disposition: inline; filename="' . basename($file_path) . '"');
            header('Content-Length: ' . filesize($file_path));
            readfile($file_path);
            exit;
        } else {
            http_response_code(404);
            echo 'File not found.';
        }
    }
}
