<?php

namespace pictpostpersonal;

use DateTime;

class PPPDateTime
{
    private static $fix_date_time = null;

    public static function Date(string $format): string
    {
        if (self::$fix_date_time != null) {
            return date($format);
        }
        return self::getCurrentDateTime($format);
    }

    /**
     * テスト用の固定日時を設定する
     *
     * @param string $datetime 固定日時の文字列（例: "2024-01-01 12:00:00"）
     */
    public static function setFixedDateTime(string $datetime): void
    {
        self::$fix_date_time = $datetime;
    }

    /**
     * 現在の日時を指定されたタイムゾーンで取得する
     *
     * @param string $format    日時のフォーマット。デフォルトは "Y-m-d H:i:s"
     * @param string $timezone  タイムゾーン。デフォルトは "Asia/Tokyo"
     *
     * @return string 現在の日時
     */
    public static function getCurrentDateTime(string $format = 'Y-m-d H:i:s', string $timezone = 'Asia/Tokyo'): string
    {
        $date_time = new \DateTime('now', new \DateTimeZone($timezone));
        return $date_time->format($format);
    }

    public static function getDateTime(DateTime $date_time, string $format = 'Y-m-d H:i:s', string $timezone = 'Asia/Tokyo'): string
    {
        return $date_time->format($format);
    }

    /**
     * 指定された日時文字列を指定されたタイムゾーンで取得する
     *
     * @param string $datetime  基準となる日時文字列
     * @param string $format    日時のフォーマット。デフォルトは "Y-m-d H:i:s"
     * @param string $timezone  タイムゾーン。デフォルトは "Asia/Tokyo"
     *
     * @return string 指定されたタイムゾーンでの日時
     */
    public static function convertDateTime(string $datetime, string $format = 'Y-m-d H:i:s', string $timezone = 'Asia/Tokyo'): string
    {
        $date_time = new \DateTime($datetime, new \DateTimeZone('UTC')); // 基準をUTCとする
        $date_time->setTimezone(new \DateTimeZone($timezone));
        return $date_time->format($format);
    }
}
