<?php

namespace pictpostpersonal;


/**
 * セッション内で1回だけ有効なメッセージを管理するクラス
 */
class FlashMessage
{
    public static function setMessage(string $flash_id, array $message_data)
    {
        \pictpostpersonal\Utility::SessionStart();
        $_SESSION["flash_messages_{$flash_id}"] = json_encode($message_data);
    }

    /**
     * フラッシュメッセージを取得する。
     * 取得後、フラッシュメッセージはクリアされる。
     *
     * @param string $flash_id  管理用ID。IDごとに異なるメッセージを保持できる。使用箇所に応じたIDを指定する。
     * @param array $defaultValue   フラッシュメッセージが空の場合に取得される値
     * 
     * @return array
     * 
     */
    public static function getMessage(string $flash_id, array $default_value = []): array
    {
        \pictpostpersonal\Utility::SessionStart();
        if (isset($_SESSION["flash_messages_{$flash_id}"])) {
            $message = $_SESSION["flash_messages_{$flash_id}"];
            unset($_SESSION["flash_messages_{$flash_id}"]);
            return json_decode($message, true);
        }
        return $default_value;
    }

    public static function clearMessage(string $flash_id)
    {
        \pictpostpersonal\Utility::SessionStart();
        unset($_SESSION["flash_messages_{$flash_id}"]);
    }
}
